/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.organization;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.contract.Document;
import org.egov.works.services.common.models.organization.Address;
import org.egov.works.services.common.models.organization.ApplicationStatus;
import org.egov.works.services.common.models.organization.ContactDetails;
import org.egov.works.services.common.models.organization.Function;
import org.egov.works.services.common.models.organization.Identifier;
import org.egov.works.services.common.models.organization.Jurisdiction;

public class Organisation {
    @JsonProperty(value="id")
    @Valid
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="name")
    @NotNull
    @Size(min=2, max=128)
    private @NotNull @Size(min=2, max=128) String name = null;
    @JsonProperty(value="applicationNumber")
    private String applicationNumber = null;
    @JsonProperty(value="orgNumber")
    private String orgNumber = null;
    @JsonProperty(value="applicationStatus")
    private ApplicationStatus applicationStatus = null;
    @JsonProperty(value="externalRefNumber")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String externalRefNumber = null;
    @JsonProperty(value="dateOfIncorporation")
    private BigDecimal dateOfIncorporation = null;
    @JsonProperty(value="orgAddress")
    @Valid
    private List<Address> orgAddress = null;
    @JsonProperty(value="contactDetails")
    @Valid
    private List<ContactDetails> contactDetails = null;
    @JsonProperty(value="identifiers")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) List<Identifier> identifiers = null;
    @JsonProperty(value="functions")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) List<Function> functions = null;
    @JsonProperty(value="jurisdiction")
    private List<Jurisdiction> jurisdiction = null;
    @JsonProperty(value="isActive")
    private Boolean isActive = null;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;

    public Organisation addOrgAddressItem(Address orgAddressItem) {
        if (this.orgAddress == null) {
            this.orgAddress = new ArrayList<Address>();
        }
        this.orgAddress.add(orgAddressItem);
        return this;
    }

    public Organisation addContactDetailsItem(ContactDetails contactDetailsItem) {
        if (this.contactDetails == null) {
            this.contactDetails = new ArrayList<ContactDetails>();
        }
        this.contactDetails.add(contactDetailsItem);
        return this;
    }

    public Organisation addIdentifiersItem(Identifier identifiersItem) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifiersItem);
        return this;
    }

    public Organisation addFunctionsItem(Function functionsItem) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.add(functionsItem);
        return this;
    }

    public Organisation addJurisdictionItem(Jurisdiction jurisdictionItem) {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<Jurisdiction>();
        }
        this.jurisdiction.add(jurisdictionItem);
        return this;
    }

    public Organisation addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public static OrganisationBuilder builder() {
        return new OrganisationBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public ApplicationStatus getApplicationStatus() {
        return this.applicationStatus;
    }

    public String getExternalRefNumber() {
        return this.externalRefNumber;
    }

    public BigDecimal getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    public List<Address> getOrgAddress() {
        return this.orgAddress;
    }

    public List<ContactDetails> getContactDetails() {
        return this.contactDetails;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Jurisdiction> getJurisdiction() {
        return this.jurisdiction;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="applicationNumber")
    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    @JsonProperty(value="orgNumber")
    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    @JsonProperty(value="applicationStatus")
    public void setApplicationStatus(ApplicationStatus applicationStatus) {
        this.applicationStatus = applicationStatus;
    }

    @JsonProperty(value="externalRefNumber")
    public void setExternalRefNumber(String externalRefNumber) {
        this.externalRefNumber = externalRefNumber;
    }

    @JsonProperty(value="dateOfIncorporation")
    public void setDateOfIncorporation(BigDecimal dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    @JsonProperty(value="orgAddress")
    public void setOrgAddress(List<Address> orgAddress) {
        this.orgAddress = orgAddress;
    }

    @JsonProperty(value="contactDetails")
    public void setContactDetails(List<ContactDetails> contactDetails) {
        this.contactDetails = contactDetails;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="functions")
    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="jurisdiction")
    public void setJurisdiction(List<Jurisdiction> jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    @JsonProperty(value="isActive")
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Organisation)) {
            return false;
        }
        Organisation other = (Organisation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$applicationNumber = this.getApplicationNumber();
        String other$applicationNumber = other.getApplicationNumber();
        if (this$applicationNumber == null ? other$applicationNumber != null : !this$applicationNumber.equals(other$applicationNumber)) {
            return false;
        }
        String this$orgNumber = this.getOrgNumber();
        String other$orgNumber = other.getOrgNumber();
        if (this$orgNumber == null ? other$orgNumber != null : !this$orgNumber.equals(other$orgNumber)) {
            return false;
        }
        ApplicationStatus this$applicationStatus = this.getApplicationStatus();
        ApplicationStatus other$applicationStatus = other.getApplicationStatus();
        if (this$applicationStatus == null ? other$applicationStatus != null : !((Object)((Object)this$applicationStatus)).equals((Object)other$applicationStatus)) {
            return false;
        }
        String this$externalRefNumber = this.getExternalRefNumber();
        String other$externalRefNumber = other.getExternalRefNumber();
        if (this$externalRefNumber == null ? other$externalRefNumber != null : !this$externalRefNumber.equals(other$externalRefNumber)) {
            return false;
        }
        BigDecimal this$dateOfIncorporation = this.getDateOfIncorporation();
        BigDecimal other$dateOfIncorporation = other.getDateOfIncorporation();
        if (this$dateOfIncorporation == null ? other$dateOfIncorporation != null : !((Object)this$dateOfIncorporation).equals(other$dateOfIncorporation)) {
            return false;
        }
        List<Address> this$orgAddress = this.getOrgAddress();
        List<Address> other$orgAddress = other.getOrgAddress();
        if (this$orgAddress == null ? other$orgAddress != null : !((Object)this$orgAddress).equals(other$orgAddress)) {
            return false;
        }
        List<ContactDetails> this$contactDetails = this.getContactDetails();
        List<ContactDetails> other$contactDetails = other.getContactDetails();
        if (this$contactDetails == null ? other$contactDetails != null : !((Object)this$contactDetails).equals(other$contactDetails)) {
            return false;
        }
        List<Identifier> this$identifiers = this.getIdentifiers();
        List<Identifier> other$identifiers = other.getIdentifiers();
        if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
            return false;
        }
        List<Function> this$functions = this.getFunctions();
        List<Function> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        List<Jurisdiction> this$jurisdiction = this.getJurisdiction();
        List<Jurisdiction> other$jurisdiction = other.getJurisdiction();
        if (this$jurisdiction == null ? other$jurisdiction != null : !((Object)this$jurisdiction).equals(other$jurisdiction)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Organisation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $applicationNumber = this.getApplicationNumber();
        result = result * 59 + ($applicationNumber == null ? 43 : $applicationNumber.hashCode());
        String $orgNumber = this.getOrgNumber();
        result = result * 59 + ($orgNumber == null ? 43 : $orgNumber.hashCode());
        ApplicationStatus $applicationStatus = this.getApplicationStatus();
        result = result * 59 + ($applicationStatus == null ? 43 : ((Object)((Object)$applicationStatus)).hashCode());
        String $externalRefNumber = this.getExternalRefNumber();
        result = result * 59 + ($externalRefNumber == null ? 43 : $externalRefNumber.hashCode());
        BigDecimal $dateOfIncorporation = this.getDateOfIncorporation();
        result = result * 59 + ($dateOfIncorporation == null ? 43 : ((Object)$dateOfIncorporation).hashCode());
        List<Address> $orgAddress = this.getOrgAddress();
        result = result * 59 + ($orgAddress == null ? 43 : ((Object)$orgAddress).hashCode());
        List<ContactDetails> $contactDetails = this.getContactDetails();
        result = result * 59 + ($contactDetails == null ? 43 : ((Object)$contactDetails).hashCode());
        List<Identifier> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        List<Function> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        List<Jurisdiction> $jurisdiction = this.getJurisdiction();
        result = result * 59 + ($jurisdiction == null ? 43 : ((Object)$jurisdiction).hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Organisation(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", name=" + this.getName() + ", applicationNumber=" + this.getApplicationNumber() + ", orgNumber=" + this.getOrgNumber() + ", applicationStatus=" + this.getApplicationStatus() + ", externalRefNumber=" + this.getExternalRefNumber() + ", dateOfIncorporation=" + this.getDateOfIncorporation() + ", orgAddress=" + this.getOrgAddress() + ", contactDetails=" + this.getContactDetails() + ", identifiers=" + this.getIdentifiers() + ", functions=" + this.getFunctions() + ", jurisdiction=" + this.getJurisdiction() + ", isActive=" + this.getIsActive() + ", documents=" + this.getDocuments() + ", additionalDetails=" + this.getAdditionalDetails() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public Organisation(String id, String tenantId, String name, String applicationNumber, String orgNumber, ApplicationStatus applicationStatus, String externalRefNumber, BigDecimal dateOfIncorporation, List<Address> orgAddress, List<ContactDetails> contactDetails, List<Identifier> identifiers, List<Function> functions, List<Jurisdiction> jurisdiction, Boolean isActive, List<Document> documents, Object additionalDetails, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.applicationNumber = applicationNumber;
        this.orgNumber = orgNumber;
        this.applicationStatus = applicationStatus;
        this.externalRefNumber = externalRefNumber;
        this.dateOfIncorporation = dateOfIncorporation;
        this.orgAddress = orgAddress;
        this.contactDetails = contactDetails;
        this.identifiers = identifiers;
        this.functions = functions;
        this.jurisdiction = jurisdiction;
        this.isActive = isActive;
        this.documents = documents;
        this.additionalDetails = additionalDetails;
        this.auditDetails = auditDetails;
    }

    public Organisation() {
    }

    public static class OrganisationBuilder {
        private String id;
        private String tenantId;
        private String name;
        private String applicationNumber;
        private String orgNumber;
        private ApplicationStatus applicationStatus;
        private String externalRefNumber;
        private BigDecimal dateOfIncorporation;
        private List<Address> orgAddress;
        private List<ContactDetails> contactDetails;
        private List<Identifier> identifiers;
        private List<Function> functions;
        private List<Jurisdiction> jurisdiction;
        private Boolean isActive;
        private List<Document> documents;
        private Object additionalDetails;
        private AuditDetails auditDetails;

        OrganisationBuilder() {
        }

        @JsonProperty(value="id")
        public OrganisationBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public OrganisationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="name")
        public OrganisationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="applicationNumber")
        public OrganisationBuilder applicationNumber(String applicationNumber) {
            this.applicationNumber = applicationNumber;
            return this;
        }

        @JsonProperty(value="orgNumber")
        public OrganisationBuilder orgNumber(String orgNumber) {
            this.orgNumber = orgNumber;
            return this;
        }

        @JsonProperty(value="applicationStatus")
        public OrganisationBuilder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @JsonProperty(value="externalRefNumber")
        public OrganisationBuilder externalRefNumber(String externalRefNumber) {
            this.externalRefNumber = externalRefNumber;
            return this;
        }

        @JsonProperty(value="dateOfIncorporation")
        public OrganisationBuilder dateOfIncorporation(BigDecimal dateOfIncorporation) {
            this.dateOfIncorporation = dateOfIncorporation;
            return this;
        }

        @JsonProperty(value="orgAddress")
        public OrganisationBuilder orgAddress(List<Address> orgAddress) {
            this.orgAddress = orgAddress;
            return this;
        }

        @JsonProperty(value="contactDetails")
        public OrganisationBuilder contactDetails(List<ContactDetails> contactDetails) {
            this.contactDetails = contactDetails;
            return this;
        }

        @JsonProperty(value="identifiers")
        public OrganisationBuilder identifiers(List<Identifier> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        @JsonProperty(value="functions")
        public OrganisationBuilder functions(List<Function> functions) {
            this.functions = functions;
            return this;
        }

        @JsonProperty(value="jurisdiction")
        public OrganisationBuilder jurisdiction(List<Jurisdiction> jurisdiction) {
            this.jurisdiction = jurisdiction;
            return this;
        }

        @JsonProperty(value="isActive")
        public OrganisationBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @JsonProperty(value="documents")
        public OrganisationBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public OrganisationBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public OrganisationBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public Organisation build() {
            return new Organisation(this.id, this.tenantId, this.name, this.applicationNumber, this.orgNumber, this.applicationStatus, this.externalRefNumber, this.dateOfIncorporation, this.orgAddress, this.contactDetails, this.identifiers, this.functions, this.jurisdiction, this.isActive, this.documents, this.additionalDetails, this.auditDetails);
        }

        public String toString() {
            return "Organisation.OrganisationBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", name=" + this.name + ", applicationNumber=" + this.applicationNumber + ", orgNumber=" + this.orgNumber + ", applicationStatus=" + this.applicationStatus + ", externalRefNumber=" + this.externalRefNumber + ", dateOfIncorporation=" + this.dateOfIncorporation + ", orgAddress=" + this.orgAddress + ", contactDetails=" + this.contactDetails + ", identifiers=" + this.identifiers + ", functions=" + this.functions + ", jurisdiction=" + this.jurisdiction + ", isActive=" + this.isActive + ", documents=" + this.documents + ", additionalDetails=" + this.additionalDetails + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

