/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.organization;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.organization.Organisation;
import org.egov.works.services.common.models.organization.Pagination;

public class OrgResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="organisations")
    @Valid
    private List<Organisation> organisations = null;
    @JsonProperty(value="pagination")
    private Pagination pagination = null;

    public OrgResponse addOrganisationsItem(Organisation organisationsItem) {
        if (this.organisations == null) {
            this.organisations = new ArrayList<Organisation>();
        }
        this.organisations.add(organisationsItem);
        return this;
    }

    public static OrgResponseBuilder builder() {
        return new OrgResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="organisations")
    public void setOrganisations(List<Organisation> organisations) {
        this.organisations = organisations;
    }

    @JsonProperty(value="pagination")
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgResponse)) {
            return false;
        }
        OrgResponse other = (OrgResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Organisation> this$organisations = this.getOrganisations();
        List<Organisation> other$organisations = other.getOrganisations();
        if (this$organisations == null ? other$organisations != null : !((Object)this$organisations).equals(other$organisations)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrgResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Organisation> $organisations = this.getOrganisations();
        result = result * 59 + ($organisations == null ? 43 : ((Object)$organisations).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public String toString() {
        return "OrgResponse(responseInfo=" + this.getResponseInfo() + ", organisations=" + this.getOrganisations() + ", pagination=" + this.getPagination() + ")";
    }

    public OrgResponse(ResponseInfo responseInfo, List<Organisation> organisations, Pagination pagination) {
        this.responseInfo = responseInfo;
        this.organisations = organisations;
        this.pagination = pagination;
    }

    public OrgResponse() {
    }

    public static class OrgResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Organisation> organisations;
        private Pagination pagination;

        OrgResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public OrgResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="organisations")
        public OrgResponseBuilder organisations(List<Organisation> organisations) {
            this.organisations = organisations;
            return this;
        }

        @JsonProperty(value="pagination")
        public OrgResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public OrgResponse build() {
            return new OrgResponse(this.responseInfo, this.organisations, this.pagination);
        }

        public String toString() {
            return "OrgResponse.OrgResponseBuilder(responseInfo=" + this.responseInfo + ", organisations=" + this.organisations + ", pagination=" + this.pagination + ")";
        }
    }
}

