/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.measurement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.works.services.common.models.measurement.MeasurementService;

public class MeasurementServiceRequest {
    @JsonProperty(value="RequestInfo")
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="measurements")
    @Valid
    @Size(message="Measurements are mandatory", min=1)
    private @Valid @Size(message="Measurements are mandatory", min=1) List<MeasurementService> measurements = null;

    public MeasurementServiceRequest addMeasurementsItem(MeasurementService measurementsItem) {
        if (this.measurements == null) {
            this.measurements = new ArrayList<MeasurementService>();
        }
        this.measurements.add(measurementsItem);
        return this;
    }

    public static MeasurementServiceRequestBuilder builder() {
        return new MeasurementServiceRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<MeasurementService> getMeasurements() {
        return this.measurements;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="measurements")
    public void setMeasurements(List<MeasurementService> measurements) {
        this.measurements = measurements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeasurementServiceRequest)) {
            return false;
        }
        MeasurementServiceRequest other = (MeasurementServiceRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<MeasurementService> this$measurements = this.getMeasurements();
        List<MeasurementService> other$measurements = other.getMeasurements();
        return !(this$measurements == null ? other$measurements != null : !((Object)this$measurements).equals(other$measurements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeasurementServiceRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<MeasurementService> $measurements = this.getMeasurements();
        result = result * 59 + ($measurements == null ? 43 : ((Object)$measurements).hashCode());
        return result;
    }

    public String toString() {
        return "MeasurementServiceRequest(requestInfo=" + this.getRequestInfo() + ", measurements=" + this.getMeasurements() + ")";
    }

    public MeasurementServiceRequest(RequestInfo requestInfo, List<MeasurementService> measurements) {
        this.requestInfo = requestInfo;
        this.measurements = measurements;
    }

    public MeasurementServiceRequest() {
    }

    public static class MeasurementServiceRequestBuilder {
        private RequestInfo requestInfo;
        private List<MeasurementService> measurements;

        MeasurementServiceRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public MeasurementServiceRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="measurements")
        public MeasurementServiceRequestBuilder measurements(List<MeasurementService> measurements) {
            this.measurements = measurements;
            return this;
        }

        public MeasurementServiceRequest build() {
            return new MeasurementServiceRequest(this.requestInfo, this.measurements);
        }

        public String toString() {
            return "MeasurementServiceRequest.MeasurementServiceRequestBuilder(requestInfo=" + this.requestInfo + ", measurements=" + this.measurements + ")";
        }
    }
}

