/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.measurement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.works.services.common.models.measurement.Measurement;

public class MeasurementRequest {
    @JsonProperty(value="RequestInfo")
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="measurements")
    @Valid
    @Size(message="At least one measurement is required", min=1)
    private @Valid @Size(message="At least one measurement is required", min=1) List<Measurement> measurements = null;

    public MeasurementRequest addMeasurementsItem(Measurement measurementsItem) {
        if (this.measurements == null) {
            this.measurements = new ArrayList<Measurement>();
        }
        this.measurements.add(measurementsItem);
        return this;
    }

    public static MeasurementRequestBuilder builder() {
        return new MeasurementRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Measurement> getMeasurements() {
        return this.measurements;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="measurements")
    public void setMeasurements(List<Measurement> measurements) {
        this.measurements = measurements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeasurementRequest)) {
            return false;
        }
        MeasurementRequest other = (MeasurementRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Measurement> this$measurements = this.getMeasurements();
        List<Measurement> other$measurements = other.getMeasurements();
        return !(this$measurements == null ? other$measurements != null : !((Object)this$measurements).equals(other$measurements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeasurementRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Measurement> $measurements = this.getMeasurements();
        result = result * 59 + ($measurements == null ? 43 : ((Object)$measurements).hashCode());
        return result;
    }

    public String toString() {
        return "MeasurementRequest(requestInfo=" + this.getRequestInfo() + ", measurements=" + this.getMeasurements() + ")";
    }

    public MeasurementRequest(RequestInfo requestInfo, List<Measurement> measurements) {
        this.requestInfo = requestInfo;
        this.measurements = measurements;
    }

    public MeasurementRequest() {
    }

    public static class MeasurementRequestBuilder {
        private RequestInfo requestInfo;
        private List<Measurement> measurements;

        MeasurementRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public MeasurementRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="measurements")
        public MeasurementRequestBuilder measurements(List<Measurement> measurements) {
            this.measurements = measurements;
            return this;
        }

        public MeasurementRequest build() {
            return new MeasurementRequest(this.requestInfo, this.measurements);
        }

        public String toString() {
            return "MeasurementRequest.MeasurementRequestBuilder(requestInfo=" + this.requestInfo + ", measurements=" + this.measurements + ")";
        }
    }
}

