/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.measurement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.models.Document;
import org.egov.works.services.common.models.measurement.Measure;

public class Measurement {
    @JsonProperty(value="id")
    @Valid
    @Size(max=64)
    private @Valid @Size(max=64) String id = null;
    @JsonProperty(value="tenantId")
    @Size(min=2, max=64)
    @NotNull
    private @Size(min=2, max=64) @NotNull String tenantId = null;
    @JsonProperty(value="measurementNumber")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String measurementNumber = null;
    @JsonProperty(value="physicalRefNumber")
    @Size(min=2, max=100)
    private @Size(min=2, max=100) String physicalRefNumber = null;
    @JsonProperty(value="referenceId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="entryDate")
    @NotNull
    @Valid
    private BigDecimal entryDate = null;
    @JsonProperty(value="measures")
    @Valid
    private List<Measure> measures = null;
    @JsonProperty(value="isActive")
    private Boolean isActive = true;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;

    public Measurement addMeasuresItem(Measure measuresItem) {
        if (this.measures == null) {
            this.measures = new ArrayList<Measure>();
        }
        this.measures.add(measuresItem);
        return this;
    }

    public static MeasurementBuilder builder() {
        return new MeasurementBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Measurement)) {
            return false;
        }
        Measurement other = (Measurement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$measurementNumber = this.getMeasurementNumber();
        String other$measurementNumber = other.getMeasurementNumber();
        if (this$measurementNumber == null ? other$measurementNumber != null : !this$measurementNumber.equals(other$measurementNumber)) {
            return false;
        }
        String this$physicalRefNumber = this.getPhysicalRefNumber();
        String other$physicalRefNumber = other.getPhysicalRefNumber();
        if (this$physicalRefNumber == null ? other$physicalRefNumber != null : !this$physicalRefNumber.equals(other$physicalRefNumber)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        BigDecimal this$entryDate = this.getEntryDate();
        BigDecimal other$entryDate = other.getEntryDate();
        if (this$entryDate == null ? other$entryDate != null : !((Object)this$entryDate).equals(other$entryDate)) {
            return false;
        }
        List<Measure> this$measures = this.getMeasures();
        List<Measure> other$measures = other.getMeasures();
        if (this$measures == null ? other$measures != null : !((Object)this$measures).equals(other$measures)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Measurement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $measurementNumber = this.getMeasurementNumber();
        result = result * 59 + ($measurementNumber == null ? 43 : $measurementNumber.hashCode());
        String $physicalRefNumber = this.getPhysicalRefNumber();
        result = result * 59 + ($physicalRefNumber == null ? 43 : $physicalRefNumber.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        BigDecimal $entryDate = this.getEntryDate();
        result = result * 59 + ($entryDate == null ? 43 : ((Object)$entryDate).hashCode());
        List<Measure> $measures = this.getMeasures();
        result = result * 59 + ($measures == null ? 43 : ((Object)$measures).hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Measurement(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", measurementNumber=" + this.getMeasurementNumber() + ", physicalRefNumber=" + this.getPhysicalRefNumber() + ", referenceId=" + this.getReferenceId() + ", entryDate=" + this.getEntryDate() + ", measures=" + this.getMeasures() + ", isActive=" + this.getIsActive() + ", documents=" + this.getDocuments() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ")";
    }

    public Measurement(String id, String tenantId, String measurementNumber, String physicalRefNumber, String referenceId, BigDecimal entryDate, List<Measure> measures, Boolean isActive, List<Document> documents, AuditDetails auditDetails, Object additionalDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.measurementNumber = measurementNumber;
        this.physicalRefNumber = physicalRefNumber;
        this.referenceId = referenceId;
        this.entryDate = entryDate;
        this.measures = measures;
        this.isActive = isActive;
        this.documents = documents;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public Measurement() {
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getMeasurementNumber() {
        return this.measurementNumber;
    }

    public String getPhysicalRefNumber() {
        return this.physicalRefNumber;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public BigDecimal getEntryDate() {
        return this.entryDate;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="measurementNumber")
    public void setMeasurementNumber(String measurementNumber) {
        this.measurementNumber = measurementNumber;
    }

    @JsonProperty(value="physicalRefNumber")
    public void setPhysicalRefNumber(String physicalRefNumber) {
        this.physicalRefNumber = physicalRefNumber;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="entryDate")
    public void setEntryDate(BigDecimal entryDate) {
        this.entryDate = entryDate;
    }

    @JsonProperty(value="measures")
    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    @JsonProperty(value="isActive")
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public static class MeasurementBuilder {
        private String id;
        private String tenantId;
        private String measurementNumber;
        private String physicalRefNumber;
        private String referenceId;
        private BigDecimal entryDate;
        private List<Measure> measures;
        private Boolean isActive;
        private List<Document> documents;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        MeasurementBuilder() {
        }

        @JsonProperty(value="id")
        public MeasurementBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public MeasurementBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="measurementNumber")
        public MeasurementBuilder measurementNumber(String measurementNumber) {
            this.measurementNumber = measurementNumber;
            return this;
        }

        @JsonProperty(value="physicalRefNumber")
        public MeasurementBuilder physicalRefNumber(String physicalRefNumber) {
            this.physicalRefNumber = physicalRefNumber;
            return this;
        }

        @JsonProperty(value="referenceId")
        public MeasurementBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="entryDate")
        public MeasurementBuilder entryDate(BigDecimal entryDate) {
            this.entryDate = entryDate;
            return this;
        }

        @JsonProperty(value="measures")
        public MeasurementBuilder measures(List<Measure> measures) {
            this.measures = measures;
            return this;
        }

        @JsonProperty(value="isActive")
        public MeasurementBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @JsonProperty(value="documents")
        public MeasurementBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public MeasurementBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public MeasurementBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public Measurement build() {
            return new Measurement(this.id, this.tenantId, this.measurementNumber, this.physicalRefNumber, this.referenceId, this.entryDate, this.measures, this.isActive, this.documents, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "Measurement.MeasurementBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", measurementNumber=" + this.measurementNumber + ", physicalRefNumber=" + this.physicalRefNumber + ", referenceId=" + this.referenceId + ", entryDate=" + this.entryDate + ", measures=" + this.measures + ", isActive=" + this.isActive + ", documents=" + this.documents + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

