/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.measurement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.models.Document;

public class Measure {
    @JsonProperty(value="id")
    @Size(max=64)
    @Valid
    private @Size(max=64) @Valid String id = null;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="targetId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String targetId = null;
    @JsonProperty(value="length")
    @Valid
    private BigDecimal length = new BigDecimal(1);
    @JsonProperty(value="breadth")
    @Valid
    private BigDecimal breadth = new BigDecimal(1);
    @JsonProperty(value="height")
    @Valid
    private BigDecimal height = new BigDecimal(1);
    @JsonProperty(value="numItems")
    @Valid
    private BigDecimal numItems = new BigDecimal(1);
    @JsonProperty(value="currentValue")
    @NotNull
    @Valid
    private BigDecimal currentValue = null;
    @JsonProperty(value="cumulativeValue")
    @Valid
    private BigDecimal cumulativeValue = null;
    @JsonProperty(value="isActive")
    private Boolean isActive = null;
    @JsonProperty(value="comments")
    @Size(min=2, max=256)
    private @Size(min=2, max=256) String comments = null;
    @JsonProperty(value="documents")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) List<Document> documents = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;

    public Measure addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public static MeasureBuilder builder() {
        return new MeasureBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    public BigDecimal getBreadth() {
        return this.breadth;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public BigDecimal getNumItems() {
        return this.numItems;
    }

    public BigDecimal getCurrentValue() {
        return this.currentValue;
    }

    public BigDecimal getCumulativeValue() {
        return this.cumulativeValue;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public String getComments() {
        return this.comments;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="targetId")
    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @JsonProperty(value="length")
    public void setLength(BigDecimal length) {
        this.length = length;
    }

    @JsonProperty(value="breadth")
    public void setBreadth(BigDecimal breadth) {
        this.breadth = breadth;
    }

    @JsonProperty(value="height")
    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    @JsonProperty(value="numItems")
    public void setNumItems(BigDecimal numItems) {
        this.numItems = numItems;
    }

    @JsonProperty(value="currentValue")
    public void setCurrentValue(BigDecimal currentValue) {
        this.currentValue = currentValue;
    }

    @JsonProperty(value="cumulativeValue")
    public void setCumulativeValue(BigDecimal cumulativeValue) {
        this.cumulativeValue = cumulativeValue;
    }

    @JsonProperty(value="isActive")
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @JsonProperty(value="comments")
    public void setComments(String comments) {
        this.comments = comments;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Measure)) {
            return false;
        }
        Measure other = (Measure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$targetId = this.getTargetId();
        String other$targetId = other.getTargetId();
        if (this$targetId == null ? other$targetId != null : !this$targetId.equals(other$targetId)) {
            return false;
        }
        BigDecimal this$length = this.getLength();
        BigDecimal other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        BigDecimal this$breadth = this.getBreadth();
        BigDecimal other$breadth = other.getBreadth();
        if (this$breadth == null ? other$breadth != null : !((Object)this$breadth).equals(other$breadth)) {
            return false;
        }
        BigDecimal this$height = this.getHeight();
        BigDecimal other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        BigDecimal this$numItems = this.getNumItems();
        BigDecimal other$numItems = other.getNumItems();
        if (this$numItems == null ? other$numItems != null : !((Object)this$numItems).equals(other$numItems)) {
            return false;
        }
        BigDecimal this$currentValue = this.getCurrentValue();
        BigDecimal other$currentValue = other.getCurrentValue();
        if (this$currentValue == null ? other$currentValue != null : !((Object)this$currentValue).equals(other$currentValue)) {
            return false;
        }
        BigDecimal this$cumulativeValue = this.getCumulativeValue();
        BigDecimal other$cumulativeValue = other.getCumulativeValue();
        if (this$cumulativeValue == null ? other$cumulativeValue != null : !((Object)this$cumulativeValue).equals(other$cumulativeValue)) {
            return false;
        }
        String this$comments = this.getComments();
        String other$comments = other.getComments();
        if (this$comments == null ? other$comments != null : !this$comments.equals(other$comments)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Measure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $targetId = this.getTargetId();
        result = result * 59 + ($targetId == null ? 43 : $targetId.hashCode());
        BigDecimal $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        BigDecimal $breadth = this.getBreadth();
        result = result * 59 + ($breadth == null ? 43 : ((Object)$breadth).hashCode());
        BigDecimal $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        BigDecimal $numItems = this.getNumItems();
        result = result * 59 + ($numItems == null ? 43 : ((Object)$numItems).hashCode());
        BigDecimal $currentValue = this.getCurrentValue();
        result = result * 59 + ($currentValue == null ? 43 : ((Object)$currentValue).hashCode());
        BigDecimal $cumulativeValue = this.getCumulativeValue();
        result = result * 59 + ($cumulativeValue == null ? 43 : ((Object)$cumulativeValue).hashCode());
        String $comments = this.getComments();
        result = result * 59 + ($comments == null ? 43 : $comments.hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Measure(id=" + this.getId() + ", referenceId=" + this.getReferenceId() + ", targetId=" + this.getTargetId() + ", length=" + this.getLength() + ", breadth=" + this.getBreadth() + ", height=" + this.getHeight() + ", numItems=" + this.getNumItems() + ", currentValue=" + this.getCurrentValue() + ", cumulativeValue=" + this.getCumulativeValue() + ", isActive=" + this.getIsActive() + ", comments=" + this.getComments() + ", documents=" + this.getDocuments() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ")";
    }

    public Measure(String id, String referenceId, String targetId, BigDecimal length, BigDecimal breadth, BigDecimal height, BigDecimal numItems, BigDecimal currentValue, BigDecimal cumulativeValue, Boolean isActive, String comments, List<Document> documents, AuditDetails auditDetails, Object additionalDetails) {
        this.id = id;
        this.referenceId = referenceId;
        this.targetId = targetId;
        this.length = length;
        this.breadth = breadth;
        this.height = height;
        this.numItems = numItems;
        this.currentValue = currentValue;
        this.cumulativeValue = cumulativeValue;
        this.isActive = isActive;
        this.comments = comments;
        this.documents = documents;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public Measure() {
    }

    public static class MeasureBuilder {
        private String id;
        private String referenceId;
        private String targetId;
        private BigDecimal length;
        private BigDecimal breadth;
        private BigDecimal height;
        private BigDecimal numItems;
        private BigDecimal currentValue;
        private BigDecimal cumulativeValue;
        private Boolean isActive;
        private String comments;
        private List<Document> documents;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        MeasureBuilder() {
        }

        @JsonProperty(value="id")
        public MeasureBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="referenceId")
        public MeasureBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="targetId")
        public MeasureBuilder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        @JsonProperty(value="length")
        public MeasureBuilder length(BigDecimal length) {
            this.length = length;
            return this;
        }

        @JsonProperty(value="breadth")
        public MeasureBuilder breadth(BigDecimal breadth) {
            this.breadth = breadth;
            return this;
        }

        @JsonProperty(value="height")
        public MeasureBuilder height(BigDecimal height) {
            this.height = height;
            return this;
        }

        @JsonProperty(value="numItems")
        public MeasureBuilder numItems(BigDecimal numItems) {
            this.numItems = numItems;
            return this;
        }

        @JsonProperty(value="currentValue")
        public MeasureBuilder currentValue(BigDecimal currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        @JsonProperty(value="cumulativeValue")
        public MeasureBuilder cumulativeValue(BigDecimal cumulativeValue) {
            this.cumulativeValue = cumulativeValue;
            return this;
        }

        @JsonProperty(value="isActive")
        public MeasureBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @JsonProperty(value="comments")
        public MeasureBuilder comments(String comments) {
            this.comments = comments;
            return this;
        }

        @JsonProperty(value="documents")
        public MeasureBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public MeasureBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public MeasureBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public Measure build() {
            return new Measure(this.id, this.referenceId, this.targetId, this.length, this.breadth, this.height, this.numItems, this.currentValue, this.cumulativeValue, this.isActive, this.comments, this.documents, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "Measure.MeasureBuilder(id=" + this.id + ", referenceId=" + this.referenceId + ", targetId=" + this.targetId + ", length=" + this.length + ", breadth=" + this.breadth + ", height=" + this.height + ", numItems=" + this.numItems + ", currentValue=" + this.currentValue + ", cumulativeValue=" + this.cumulativeValue + ", isActive=" + this.isActive + ", comments=" + this.comments + ", documents=" + this.documents + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

