/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense.calculator;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.models.Document;
import org.egov.common.contract.models.Workflow;
import org.egov.works.services.common.models.expense.BillDetail;
import org.egov.works.services.common.models.expense.Party;

public class PurchaseBill {
    @JsonProperty(value="id")
    @Valid
    private String id;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="invoiceDate")
    @Valid
    private Long invoiceDate;
    @JsonProperty(value="invoiceNumber")
    @Valid
    private String invoiceNumber;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=128)
    private @Size(min=2, max=128) String referenceId;
    @JsonProperty(value="billNumber")
    private String billNumber;
    @JsonProperty(value="contractNumber")
    @Valid
    private String contractNumber;
    @JsonProperty(value="projectId")
    @Valid
    private String projectId;
    @JsonProperty(value="status")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String status;
    @JsonProperty(value="billDetails")
    @NotNull
    @Valid
    private List<BillDetail> billDetails;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="workflow")
    private Workflow workflow;
    @JsonProperty(value="payer")
    private Party party;
    @JsonProperty(value="billDate")
    @Valid
    private Long billDate;
    @JsonProperty(value="dueDate")
    @Valid
    private Long dueDate;
    @JsonProperty(value="totalAmount")
    @Valid
    private BigDecimal totalAmount;
    @JsonProperty(value="totalPaidAmount")
    @Valid
    private BigDecimal totalPaidAmount;
    @JsonProperty(value="businessService")
    @NotNull
    @Size(min=2, max=128)
    private @NotNull @Size(min=2, max=128) String businessService;
    @JsonProperty(value="fromPeriod")
    @Valid
    private Long fromPeriod;
    @JsonProperty(value="toPeriod")
    @Valid
    private Long toPeriod;
    @JsonProperty(value="paymentStatus")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String paymentStatus;
    @JsonProperty(value="wfStatus")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String wfStatus;

    public PurchaseBill addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public PurchaseBill addBillDetailsItem(BillDetail billDetailsItem) {
        if (null == this.billDetails) {
            this.billDetails = new ArrayList<BillDetail>();
        }
        this.billDetails.add(billDetailsItem);
        return this;
    }

    private static BigDecimal $default$totalAmount() {
        return BigDecimal.ZERO;
    }

    private static BigDecimal $default$totalPaidAmount() {
        return BigDecimal.ZERO;
    }

    public static PurchaseBillBuilder builder() {
        return new PurchaseBillBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getInvoiceDate() {
        return this.invoiceDate;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getStatus() {
        return this.status;
    }

    public List<BillDetail> getBillDetails() {
        return this.billDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public Party getParty() {
        return this.party;
    }

    public Long getBillDate() {
        return this.billDate;
    }

    public Long getDueDate() {
        return this.dueDate;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getTotalPaidAmount() {
        return this.totalPaidAmount;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public Long getFromPeriod() {
        return this.fromPeriod;
    }

    public Long getToPeriod() {
        return this.toPeriod;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getWfStatus() {
        return this.wfStatus;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="invoiceDate")
    public void setInvoiceDate(Long invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    @JsonProperty(value="invoiceNumber")
    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="billNumber")
    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    @JsonProperty(value="contractNumber")
    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="billDetails")
    public void setBillDetails(List<BillDetail> billDetails) {
        this.billDetails = billDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="workflow")
    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    @JsonProperty(value="payer")
    public void setParty(Party party) {
        this.party = party;
    }

    @JsonProperty(value="billDate")
    public void setBillDate(Long billDate) {
        this.billDate = billDate;
    }

    @JsonProperty(value="dueDate")
    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="totalPaidAmount")
    public void setTotalPaidAmount(BigDecimal totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="fromPeriod")
    public void setFromPeriod(Long fromPeriod) {
        this.fromPeriod = fromPeriod;
    }

    @JsonProperty(value="toPeriod")
    public void setToPeriod(Long toPeriod) {
        this.toPeriod = toPeriod;
    }

    @JsonProperty(value="paymentStatus")
    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @JsonProperty(value="wfStatus")
    public void setWfStatus(String wfStatus) {
        this.wfStatus = wfStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurchaseBill)) {
            return false;
        }
        PurchaseBill other = (PurchaseBill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$invoiceDate = this.getInvoiceDate();
        Long other$invoiceDate = other.getInvoiceDate();
        if (this$invoiceDate == null ? other$invoiceDate != null : !((Object)this$invoiceDate).equals(other$invoiceDate)) {
            return false;
        }
        Long this$billDate = this.getBillDate();
        Long other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !((Object)this$billDate).equals(other$billDate)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$fromPeriod = this.getFromPeriod();
        Long other$fromPeriod = other.getFromPeriod();
        if (this$fromPeriod == null ? other$fromPeriod != null : !((Object)this$fromPeriod).equals(other$fromPeriod)) {
            return false;
        }
        Long this$toPeriod = this.getToPeriod();
        Long other$toPeriod = other.getToPeriod();
        if (this$toPeriod == null ? other$toPeriod != null : !((Object)this$toPeriod).equals(other$toPeriod)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$invoiceNumber = this.getInvoiceNumber();
        String other$invoiceNumber = other.getInvoiceNumber();
        if (this$invoiceNumber == null ? other$invoiceNumber != null : !this$invoiceNumber.equals(other$invoiceNumber)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$billNumber = this.getBillNumber();
        String other$billNumber = other.getBillNumber();
        if (this$billNumber == null ? other$billNumber != null : !this$billNumber.equals(other$billNumber)) {
            return false;
        }
        String this$contractNumber = this.getContractNumber();
        String other$contractNumber = other.getContractNumber();
        if (this$contractNumber == null ? other$contractNumber != null : !this$contractNumber.equals(other$contractNumber)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<BillDetail> this$billDetails = this.getBillDetails();
        List<BillDetail> other$billDetails = other.getBillDetails();
        if (this$billDetails == null ? other$billDetails != null : !((Object)this$billDetails).equals(other$billDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Workflow this$workflow = this.getWorkflow();
        Workflow other$workflow = other.getWorkflow();
        if (this$workflow == null ? other$workflow != null : !this$workflow.equals(other$workflow)) {
            return false;
        }
        Party this$party = this.getParty();
        Party other$party = other.getParty();
        if (this$party == null ? other$party != null : !((Object)this$party).equals(other$party)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$totalPaidAmount = this.getTotalPaidAmount();
        BigDecimal other$totalPaidAmount = other.getTotalPaidAmount();
        if (this$totalPaidAmount == null ? other$totalPaidAmount != null : !((Object)this$totalPaidAmount).equals(other$totalPaidAmount)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        if (this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService)) {
            return false;
        }
        String this$paymentStatus = this.getPaymentStatus();
        String other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !this$paymentStatus.equals(other$paymentStatus)) {
            return false;
        }
        String this$wfStatus = this.getWfStatus();
        String other$wfStatus = other.getWfStatus();
        return !(this$wfStatus == null ? other$wfStatus != null : !this$wfStatus.equals(other$wfStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PurchaseBill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $invoiceDate = this.getInvoiceDate();
        result = result * 59 + ($invoiceDate == null ? 43 : ((Object)$invoiceDate).hashCode());
        Long $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : ((Object)$billDate).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $fromPeriod = this.getFromPeriod();
        result = result * 59 + ($fromPeriod == null ? 43 : ((Object)$fromPeriod).hashCode());
        Long $toPeriod = this.getToPeriod();
        result = result * 59 + ($toPeriod == null ? 43 : ((Object)$toPeriod).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $invoiceNumber = this.getInvoiceNumber();
        result = result * 59 + ($invoiceNumber == null ? 43 : $invoiceNumber.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $billNumber = this.getBillNumber();
        result = result * 59 + ($billNumber == null ? 43 : $billNumber.hashCode());
        String $contractNumber = this.getContractNumber();
        result = result * 59 + ($contractNumber == null ? 43 : $contractNumber.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<BillDetail> $billDetails = this.getBillDetails();
        result = result * 59 + ($billDetails == null ? 43 : ((Object)$billDetails).hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Workflow $workflow = this.getWorkflow();
        result = result * 59 + ($workflow == null ? 43 : $workflow.hashCode());
        Party $party = this.getParty();
        result = result * 59 + ($party == null ? 43 : ((Object)$party).hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $totalPaidAmount = this.getTotalPaidAmount();
        result = result * 59 + ($totalPaidAmount == null ? 43 : ((Object)$totalPaidAmount).hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        String $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : $paymentStatus.hashCode());
        String $wfStatus = this.getWfStatus();
        result = result * 59 + ($wfStatus == null ? 43 : $wfStatus.hashCode());
        return result;
    }

    public String toString() {
        return "PurchaseBill(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", invoiceDate=" + this.getInvoiceDate() + ", invoiceNumber=" + this.getInvoiceNumber() + ", referenceId=" + this.getReferenceId() + ", billNumber=" + this.getBillNumber() + ", contractNumber=" + this.getContractNumber() + ", projectId=" + this.getProjectId() + ", status=" + this.getStatus() + ", billDetails=" + this.getBillDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ", auditDetails=" + this.getAuditDetails() + ", documents=" + this.getDocuments() + ", workflow=" + this.getWorkflow() + ", party=" + this.getParty() + ", billDate=" + this.getBillDate() + ", dueDate=" + this.getDueDate() + ", totalAmount=" + this.getTotalAmount() + ", totalPaidAmount=" + this.getTotalPaidAmount() + ", businessService=" + this.getBusinessService() + ", fromPeriod=" + this.getFromPeriod() + ", toPeriod=" + this.getToPeriod() + ", paymentStatus=" + this.getPaymentStatus() + ", wfStatus=" + this.getWfStatus() + ")";
    }

    public PurchaseBill(String id, String tenantId, Long invoiceDate, String invoiceNumber, String referenceId, String billNumber, String contractNumber, String projectId, String status, List<BillDetail> billDetails, Object additionalDetails, AuditDetails auditDetails, List<Document> documents, Workflow workflow, Party party, Long billDate, Long dueDate, BigDecimal totalAmount, BigDecimal totalPaidAmount, String businessService, Long fromPeriod, Long toPeriod, String paymentStatus, String wfStatus) {
        this.id = id;
        this.tenantId = tenantId;
        this.invoiceDate = invoiceDate;
        this.invoiceNumber = invoiceNumber;
        this.referenceId = referenceId;
        this.billNumber = billNumber;
        this.contractNumber = contractNumber;
        this.projectId = projectId;
        this.status = status;
        this.billDetails = billDetails;
        this.additionalDetails = additionalDetails;
        this.auditDetails = auditDetails;
        this.documents = documents;
        this.workflow = workflow;
        this.party = party;
        this.billDate = billDate;
        this.dueDate = dueDate;
        this.totalAmount = totalAmount;
        this.totalPaidAmount = totalPaidAmount;
        this.businessService = businessService;
        this.fromPeriod = fromPeriod;
        this.toPeriod = toPeriod;
        this.paymentStatus = paymentStatus;
        this.wfStatus = wfStatus;
    }

    public PurchaseBill() {
        this.totalAmount = PurchaseBill.$default$totalAmount();
        this.totalPaidAmount = PurchaseBill.$default$totalPaidAmount();
    }

    public static class PurchaseBillBuilder {
        private String id;
        private String tenantId;
        private Long invoiceDate;
        private String invoiceNumber;
        private String referenceId;
        private String billNumber;
        private String contractNumber;
        private String projectId;
        private String status;
        private List<BillDetail> billDetails;
        private Object additionalDetails;
        private AuditDetails auditDetails;
        private List<Document> documents;
        private Workflow workflow;
        private Party party;
        private Long billDate;
        private Long dueDate;
        private boolean totalAmount$set;
        private BigDecimal totalAmount$value;
        private boolean totalPaidAmount$set;
        private BigDecimal totalPaidAmount$value;
        private String businessService;
        private Long fromPeriod;
        private Long toPeriod;
        private String paymentStatus;
        private String wfStatus;

        PurchaseBillBuilder() {
        }

        @JsonProperty(value="id")
        public PurchaseBillBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public PurchaseBillBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="invoiceDate")
        public PurchaseBillBuilder invoiceDate(Long invoiceDate) {
            this.invoiceDate = invoiceDate;
            return this;
        }

        @JsonProperty(value="invoiceNumber")
        public PurchaseBillBuilder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            return this;
        }

        @JsonProperty(value="referenceId")
        public PurchaseBillBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="billNumber")
        public PurchaseBillBuilder billNumber(String billNumber) {
            this.billNumber = billNumber;
            return this;
        }

        @JsonProperty(value="contractNumber")
        public PurchaseBillBuilder contractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
            return this;
        }

        @JsonProperty(value="projectId")
        public PurchaseBillBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="status")
        public PurchaseBillBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="billDetails")
        public PurchaseBillBuilder billDetails(List<BillDetail> billDetails) {
            this.billDetails = billDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public PurchaseBillBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public PurchaseBillBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="documents")
        public PurchaseBillBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="workflow")
        public PurchaseBillBuilder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        @JsonProperty(value="payer")
        public PurchaseBillBuilder party(Party party) {
            this.party = party;
            return this;
        }

        @JsonProperty(value="billDate")
        public PurchaseBillBuilder billDate(Long billDate) {
            this.billDate = billDate;
            return this;
        }

        @JsonProperty(value="dueDate")
        public PurchaseBillBuilder dueDate(Long dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public PurchaseBillBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount$value = totalAmount;
            this.totalAmount$set = true;
            return this;
        }

        @JsonProperty(value="totalPaidAmount")
        public PurchaseBillBuilder totalPaidAmount(BigDecimal totalPaidAmount) {
            this.totalPaidAmount$value = totalPaidAmount;
            this.totalPaidAmount$set = true;
            return this;
        }

        @JsonProperty(value="businessService")
        public PurchaseBillBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="fromPeriod")
        public PurchaseBillBuilder fromPeriod(Long fromPeriod) {
            this.fromPeriod = fromPeriod;
            return this;
        }

        @JsonProperty(value="toPeriod")
        public PurchaseBillBuilder toPeriod(Long toPeriod) {
            this.toPeriod = toPeriod;
            return this;
        }

        @JsonProperty(value="paymentStatus")
        public PurchaseBillBuilder paymentStatus(String paymentStatus) {
            this.paymentStatus = paymentStatus;
            return this;
        }

        @JsonProperty(value="wfStatus")
        public PurchaseBillBuilder wfStatus(String wfStatus) {
            this.wfStatus = wfStatus;
            return this;
        }

        public PurchaseBill build() {
            BigDecimal totalAmount$value = this.totalAmount$value;
            if (!this.totalAmount$set) {
                totalAmount$value = PurchaseBill.$default$totalAmount();
            }
            BigDecimal totalPaidAmount$value = this.totalPaidAmount$value;
            if (!this.totalPaidAmount$set) {
                totalPaidAmount$value = PurchaseBill.$default$totalPaidAmount();
            }
            return new PurchaseBill(this.id, this.tenantId, this.invoiceDate, this.invoiceNumber, this.referenceId, this.billNumber, this.contractNumber, this.projectId, this.status, this.billDetails, this.additionalDetails, this.auditDetails, this.documents, this.workflow, this.party, this.billDate, this.dueDate, totalAmount$value, totalPaidAmount$value, this.businessService, this.fromPeriod, this.toPeriod, this.paymentStatus, this.wfStatus);
        }

        public String toString() {
            return "PurchaseBill.PurchaseBillBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", invoiceDate=" + this.invoiceDate + ", invoiceNumber=" + this.invoiceNumber + ", referenceId=" + this.referenceId + ", billNumber=" + this.billNumber + ", contractNumber=" + this.contractNumber + ", projectId=" + this.projectId + ", status=" + this.status + ", billDetails=" + this.billDetails + ", additionalDetails=" + this.additionalDetails + ", auditDetails=" + this.auditDetails + ", documents=" + this.documents + ", workflow=" + this.workflow + ", party=" + this.party + ", billDate=" + this.billDate + ", dueDate=" + this.dueDate + ", totalAmount$value=" + this.totalAmount$value + ", totalPaidAmount$value=" + this.totalPaidAmount$value + ", businessService=" + this.businessService + ", fromPeriod=" + this.fromPeriod + ", toPeriod=" + this.toPeriod + ", paymentStatus=" + this.paymentStatus + ", wfStatus=" + this.wfStatus + ")";
        }
    }
}

