/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense.calculator;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.calculator.AttendanceEntry;

public class IndividualEntry {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="individualId")
    private String individualId = null;
    @JsonProperty(value="actualTotalAttendance")
    private BigDecimal actualTotalAttendance = null;
    @JsonProperty(value="modifiedTotalAttendance")
    private BigDecimal modifiedTotalAttendance = null;
    @JsonProperty(value="attendanceEntries")
    @Valid
    private List<AttendanceEntry> attendanceEntries = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;

    public IndividualEntry addAttendanceEntriesItem(AttendanceEntry attendanceEntriesItem) {
        if (this.attendanceEntries == null) {
            this.attendanceEntries = new ArrayList<AttendanceEntry>();
        }
        this.attendanceEntries.add(attendanceEntriesItem);
        return this;
    }

    public static IndividualEntryBuilder builder() {
        return new IndividualEntryBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public BigDecimal getActualTotalAttendance() {
        return this.actualTotalAttendance;
    }

    public BigDecimal getModifiedTotalAttendance() {
        return this.modifiedTotalAttendance;
    }

    public List<AttendanceEntry> getAttendanceEntries() {
        return this.attendanceEntries;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="actualTotalAttendance")
    public void setActualTotalAttendance(BigDecimal actualTotalAttendance) {
        this.actualTotalAttendance = actualTotalAttendance;
    }

    @JsonProperty(value="modifiedTotalAttendance")
    public void setModifiedTotalAttendance(BigDecimal modifiedTotalAttendance) {
        this.modifiedTotalAttendance = modifiedTotalAttendance;
    }

    @JsonProperty(value="attendanceEntries")
    public void setAttendanceEntries(List<AttendanceEntry> attendanceEntries) {
        this.attendanceEntries = attendanceEntries;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public IndividualEntry(String id, String individualId, BigDecimal actualTotalAttendance, BigDecimal modifiedTotalAttendance, List<AttendanceEntry> attendanceEntries, Object additionalDetails, AuditDetails auditDetails) {
        this.id = id;
        this.individualId = individualId;
        this.actualTotalAttendance = actualTotalAttendance;
        this.modifiedTotalAttendance = modifiedTotalAttendance;
        this.attendanceEntries = attendanceEntries;
        this.additionalDetails = additionalDetails;
        this.auditDetails = auditDetails;
    }

    public IndividualEntry() {
    }

    public static class IndividualEntryBuilder {
        private String id;
        private String individualId;
        private BigDecimal actualTotalAttendance;
        private BigDecimal modifiedTotalAttendance;
        private List<AttendanceEntry> attendanceEntries;
        private Object additionalDetails;
        private AuditDetails auditDetails;

        IndividualEntryBuilder() {
        }

        @JsonProperty(value="id")
        public IndividualEntryBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="individualId")
        public IndividualEntryBuilder individualId(String individualId) {
            this.individualId = individualId;
            return this;
        }

        @JsonProperty(value="actualTotalAttendance")
        public IndividualEntryBuilder actualTotalAttendance(BigDecimal actualTotalAttendance) {
            this.actualTotalAttendance = actualTotalAttendance;
            return this;
        }

        @JsonProperty(value="modifiedTotalAttendance")
        public IndividualEntryBuilder modifiedTotalAttendance(BigDecimal modifiedTotalAttendance) {
            this.modifiedTotalAttendance = modifiedTotalAttendance;
            return this;
        }

        @JsonProperty(value="attendanceEntries")
        public IndividualEntryBuilder attendanceEntries(List<AttendanceEntry> attendanceEntries) {
            this.attendanceEntries = attendanceEntries;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public IndividualEntryBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public IndividualEntryBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public IndividualEntry build() {
            return new IndividualEntry(this.id, this.individualId, this.actualTotalAttendance, this.modifiedTotalAttendance, this.attendanceEntries, this.additionalDetails, this.auditDetails);
        }

        public String toString() {
            return "IndividualEntry.IndividualEntryBuilder(id=" + this.id + ", individualId=" + this.individualId + ", actualTotalAttendance=" + this.actualTotalAttendance + ", modifiedTotalAttendance=" + this.modifiedTotalAttendance + ", attendanceEntries=" + this.attendanceEntries + ", additionalDetails=" + this.additionalDetails + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

