/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense.calculator;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.calculator.CalcEstimate;

public class Calculation {
    @JsonProperty(value="tenantId")
    @NotNull
    private String tenantId = null;
    @JsonProperty(value="estimates")
    @Valid
    private List<CalcEstimate> estimates = null;
    @JsonProperty(value="totalAmount")
    @Valid
    private BigDecimal totalAmount = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public Calculation addEstimatesItem(CalcEstimate estimatesItem) {
        if (this.estimates == null) {
            this.estimates = new ArrayList<CalcEstimate>();
        }
        this.estimates.add(estimatesItem);
        return this;
    }

    public static CalculationBuilder builder() {
        return new CalculationBuilder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<CalcEstimate> getEstimates() {
        return this.estimates;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="estimates")
    public void setEstimates(List<CalcEstimate> estimates) {
        this.estimates = estimates;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Calculation)) {
            return false;
        }
        Calculation other = (Calculation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        List<CalcEstimate> this$estimates = this.getEstimates();
        List<CalcEstimate> other$estimates = other.getEstimates();
        if (this$estimates == null ? other$estimates != null : !((Object)this$estimates).equals(other$estimates)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Calculation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        List<CalcEstimate> $estimates = this.getEstimates();
        result = result * 59 + ($estimates == null ? 43 : ((Object)$estimates).hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Calculation(tenantId=" + this.getTenantId() + ", estimates=" + this.getEstimates() + ", totalAmount=" + this.getTotalAmount() + ", additionalDetails=" + this.getAdditionalDetails() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public Calculation(String tenantId, List<CalcEstimate> estimates, BigDecimal totalAmount, Object additionalDetails, AuditDetails auditDetails) {
        this.tenantId = tenantId;
        this.estimates = estimates;
        this.totalAmount = totalAmount;
        this.additionalDetails = additionalDetails;
        this.auditDetails = auditDetails;
    }

    public Calculation() {
    }

    public static class CalculationBuilder {
        private String tenantId;
        private List<CalcEstimate> estimates;
        private BigDecimal totalAmount;
        private Object additionalDetails;
        private AuditDetails auditDetails;

        CalculationBuilder() {
        }

        @JsonProperty(value="tenantId")
        public CalculationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="estimates")
        public CalculationBuilder estimates(List<CalcEstimate> estimates) {
            this.estimates = estimates;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public CalculationBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public CalculationBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public CalculationBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public Calculation build() {
            return new Calculation(this.tenantId, this.estimates, this.totalAmount, this.additionalDetails, this.auditDetails);
        }

        public String toString() {
            return "Calculation.CalculationBuilder(tenantId=" + this.tenantId + ", estimates=" + this.estimates + ", totalAmount=" + this.totalAmount + ", additionalDetails=" + this.additionalDetails + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

