/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense.calculator;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.calculator.CalcDetail;

public class CalcEstimate {
    @JsonProperty(value="id")
    @Valid
    private UUID id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="netPayableAmount")
    @Valid
    private BigDecimal netPayableAmount = null;
    @JsonProperty(value="businessService")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String businessService = null;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="fromPeriod")
    @Valid
    private BigDecimal fromPeriod = null;
    @JsonProperty(value="toPeriod")
    @Valid
    private BigDecimal toPeriod = null;
    @JsonProperty(value="calcDetails")
    @Valid
    private List<CalcDetail> calcDetails = null;
    @JsonProperty(value="additionalFields")
    private Object additionalFields = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public CalcEstimate addCalcDetailsItem(CalcDetail calcDetailsItem) {
        if (this.calcDetails == null) {
            this.calcDetails = new ArrayList<CalcDetail>();
        }
        this.calcDetails.add(calcDetailsItem);
        return this;
    }

    public static CalcEstimateBuilder builder() {
        return new CalcEstimateBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public BigDecimal getNetPayableAmount() {
        return this.netPayableAmount;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public BigDecimal getFromPeriod() {
        return this.fromPeriod;
    }

    public BigDecimal getToPeriod() {
        return this.toPeriod;
    }

    public List<CalcDetail> getCalcDetails() {
        return this.calcDetails;
    }

    public Object getAdditionalFields() {
        return this.additionalFields;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="netPayableAmount")
    public void setNetPayableAmount(BigDecimal netPayableAmount) {
        this.netPayableAmount = netPayableAmount;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="fromPeriod")
    public void setFromPeriod(BigDecimal fromPeriod) {
        this.fromPeriod = fromPeriod;
    }

    @JsonProperty(value="toPeriod")
    public void setToPeriod(BigDecimal toPeriod) {
        this.toPeriod = toPeriod;
    }

    @JsonProperty(value="calcDetails")
    public void setCalcDetails(List<CalcDetail> calcDetails) {
        this.calcDetails = calcDetails;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(Object additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalcEstimate)) {
            return false;
        }
        CalcEstimate other = (CalcEstimate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        BigDecimal this$netPayableAmount = this.getNetPayableAmount();
        BigDecimal other$netPayableAmount = other.getNetPayableAmount();
        if (this$netPayableAmount == null ? other$netPayableAmount != null : !((Object)this$netPayableAmount).equals(other$netPayableAmount)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        if (this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        BigDecimal this$fromPeriod = this.getFromPeriod();
        BigDecimal other$fromPeriod = other.getFromPeriod();
        if (this$fromPeriod == null ? other$fromPeriod != null : !((Object)this$fromPeriod).equals(other$fromPeriod)) {
            return false;
        }
        BigDecimal this$toPeriod = this.getToPeriod();
        BigDecimal other$toPeriod = other.getToPeriod();
        if (this$toPeriod == null ? other$toPeriod != null : !((Object)this$toPeriod).equals(other$toPeriod)) {
            return false;
        }
        List<CalcDetail> this$calcDetails = this.getCalcDetails();
        List<CalcDetail> other$calcDetails = other.getCalcDetails();
        if (this$calcDetails == null ? other$calcDetails != null : !((Object)this$calcDetails).equals(other$calcDetails)) {
            return false;
        }
        Object this$additionalFields = this.getAdditionalFields();
        Object other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !this$additionalFields.equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalcEstimate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        BigDecimal $netPayableAmount = this.getNetPayableAmount();
        result = result * 59 + ($netPayableAmount == null ? 43 : ((Object)$netPayableAmount).hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        BigDecimal $fromPeriod = this.getFromPeriod();
        result = result * 59 + ($fromPeriod == null ? 43 : ((Object)$fromPeriod).hashCode());
        BigDecimal $toPeriod = this.getToPeriod();
        result = result * 59 + ($toPeriod == null ? 43 : ((Object)$toPeriod).hashCode());
        List<CalcDetail> $calcDetails = this.getCalcDetails();
        result = result * 59 + ($calcDetails == null ? 43 : ((Object)$calcDetails).hashCode());
        Object $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : $additionalFields.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "CalcEstimate(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", netPayableAmount=" + this.getNetPayableAmount() + ", businessService=" + this.getBusinessService() + ", referenceId=" + this.getReferenceId() + ", fromPeriod=" + this.getFromPeriod() + ", toPeriod=" + this.getToPeriod() + ", calcDetails=" + this.getCalcDetails() + ", additionalFields=" + this.getAdditionalFields() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public CalcEstimate(UUID id, String tenantId, BigDecimal netPayableAmount, String businessService, String referenceId, BigDecimal fromPeriod, BigDecimal toPeriod, List<CalcDetail> calcDetails, Object additionalFields, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.netPayableAmount = netPayableAmount;
        this.businessService = businessService;
        this.referenceId = referenceId;
        this.fromPeriod = fromPeriod;
        this.toPeriod = toPeriod;
        this.calcDetails = calcDetails;
        this.additionalFields = additionalFields;
        this.auditDetails = auditDetails;
    }

    public CalcEstimate() {
    }

    public static class CalcEstimateBuilder {
        private UUID id;
        private String tenantId;
        private BigDecimal netPayableAmount;
        private String businessService;
        private String referenceId;
        private BigDecimal fromPeriod;
        private BigDecimal toPeriod;
        private List<CalcDetail> calcDetails;
        private Object additionalFields;
        private AuditDetails auditDetails;

        CalcEstimateBuilder() {
        }

        @JsonProperty(value="id")
        public CalcEstimateBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public CalcEstimateBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="netPayableAmount")
        public CalcEstimateBuilder netPayableAmount(BigDecimal netPayableAmount) {
            this.netPayableAmount = netPayableAmount;
            return this;
        }

        @JsonProperty(value="businessService")
        public CalcEstimateBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="referenceId")
        public CalcEstimateBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="fromPeriod")
        public CalcEstimateBuilder fromPeriod(BigDecimal fromPeriod) {
            this.fromPeriod = fromPeriod;
            return this;
        }

        @JsonProperty(value="toPeriod")
        public CalcEstimateBuilder toPeriod(BigDecimal toPeriod) {
            this.toPeriod = toPeriod;
            return this;
        }

        @JsonProperty(value="calcDetails")
        public CalcEstimateBuilder calcDetails(List<CalcDetail> calcDetails) {
            this.calcDetails = calcDetails;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public CalcEstimateBuilder additionalFields(Object additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public CalcEstimateBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public CalcEstimate build() {
            return new CalcEstimate(this.id, this.tenantId, this.netPayableAmount, this.businessService, this.referenceId, this.fromPeriod, this.toPeriod, this.calcDetails, this.additionalFields, this.auditDetails);
        }

        public String toString() {
            return "CalcEstimate.CalcEstimateBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", netPayableAmount=" + this.netPayableAmount + ", businessService=" + this.businessService + ", referenceId=" + this.referenceId + ", fromPeriod=" + this.fromPeriod + ", toPeriod=" + this.toPeriod + ", calcDetails=" + this.calcDetails + ", additionalFields=" + this.additionalFields + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

