/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense.calculator;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.egov.works.services.common.models.expense.Party;
import org.egov.works.services.common.models.expense.calculator.LineItem;

public class CalcDetail {
    @JsonProperty(value="id")
    @Valid
    private UUID id = null;
    @JsonProperty(value="billId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String billId = null;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="fromPeriod")
    @Valid
    private BigDecimal fromPeriod = null;
    @JsonProperty(value="toPeriod")
    @Valid
    private BigDecimal toPeriod = null;
    @JsonProperty(value="payee")
    @Valid
    private Party payee = null;
    @JsonProperty(value="lineItems")
    @Valid
    private List<LineItem> lineItems = null;
    @JsonProperty(value="payableLineItem")
    @NotNull
    @Valid
    private List<LineItem> payableLineItem = new ArrayList<LineItem>();

    public CalcDetail addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    public CalcDetail addPayableLineItemItem(LineItem payableLineItemItem) {
        this.payableLineItem.add(payableLineItemItem);
        return this;
    }

    public static CalcDetailBuilder builder() {
        return new CalcDetailBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getBillId() {
        return this.billId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public BigDecimal getFromPeriod() {
        return this.fromPeriod;
    }

    public BigDecimal getToPeriod() {
        return this.toPeriod;
    }

    public Party getPayee() {
        return this.payee;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public List<LineItem> getPayableLineItem() {
        return this.payableLineItem;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    @JsonProperty(value="billId")
    public void setBillId(String billId) {
        this.billId = billId;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="fromPeriod")
    public void setFromPeriod(BigDecimal fromPeriod) {
        this.fromPeriod = fromPeriod;
    }

    @JsonProperty(value="toPeriod")
    public void setToPeriod(BigDecimal toPeriod) {
        this.toPeriod = toPeriod;
    }

    @JsonProperty(value="payee")
    public void setPayee(Party payee) {
        this.payee = payee;
    }

    @JsonProperty(value="lineItems")
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    @JsonProperty(value="payableLineItem")
    public void setPayableLineItem(List<LineItem> payableLineItem) {
        this.payableLineItem = payableLineItem;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalcDetail)) {
            return false;
        }
        CalcDetail other = (CalcDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$billId = this.getBillId();
        String other$billId = other.getBillId();
        if (this$billId == null ? other$billId != null : !this$billId.equals(other$billId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        BigDecimal this$fromPeriod = this.getFromPeriod();
        BigDecimal other$fromPeriod = other.getFromPeriod();
        if (this$fromPeriod == null ? other$fromPeriod != null : !((Object)this$fromPeriod).equals(other$fromPeriod)) {
            return false;
        }
        BigDecimal this$toPeriod = this.getToPeriod();
        BigDecimal other$toPeriod = other.getToPeriod();
        if (this$toPeriod == null ? other$toPeriod != null : !((Object)this$toPeriod).equals(other$toPeriod)) {
            return false;
        }
        Party this$payee = this.getPayee();
        Party other$payee = other.getPayee();
        if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
            return false;
        }
        List<LineItem> this$lineItems = this.getLineItems();
        List<LineItem> other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        List<LineItem> this$payableLineItem = this.getPayableLineItem();
        List<LineItem> other$payableLineItem = other.getPayableLineItem();
        return !(this$payableLineItem == null ? other$payableLineItem != null : !((Object)this$payableLineItem).equals(other$payableLineItem));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalcDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $billId = this.getBillId();
        result = result * 59 + ($billId == null ? 43 : $billId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        BigDecimal $fromPeriod = this.getFromPeriod();
        result = result * 59 + ($fromPeriod == null ? 43 : ((Object)$fromPeriod).hashCode());
        BigDecimal $toPeriod = this.getToPeriod();
        result = result * 59 + ($toPeriod == null ? 43 : ((Object)$toPeriod).hashCode());
        Party $payee = this.getPayee();
        result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
        List<LineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        List<LineItem> $payableLineItem = this.getPayableLineItem();
        result = result * 59 + ($payableLineItem == null ? 43 : ((Object)$payableLineItem).hashCode());
        return result;
    }

    public String toString() {
        return "CalcDetail(id=" + this.getId() + ", billId=" + this.getBillId() + ", referenceId=" + this.getReferenceId() + ", fromPeriod=" + this.getFromPeriod() + ", toPeriod=" + this.getToPeriod() + ", payee=" + this.getPayee() + ", lineItems=" + this.getLineItems() + ", payableLineItem=" + this.getPayableLineItem() + ")";
    }

    public CalcDetail(UUID id, String billId, String referenceId, BigDecimal fromPeriod, BigDecimal toPeriod, Party payee, List<LineItem> lineItems, List<LineItem> payableLineItem) {
        this.id = id;
        this.billId = billId;
        this.referenceId = referenceId;
        this.fromPeriod = fromPeriod;
        this.toPeriod = toPeriod;
        this.payee = payee;
        this.lineItems = lineItems;
        this.payableLineItem = payableLineItem;
    }

    public CalcDetail() {
    }

    public static class CalcDetailBuilder {
        private UUID id;
        private String billId;
        private String referenceId;
        private BigDecimal fromPeriod;
        private BigDecimal toPeriod;
        private Party payee;
        private List<LineItem> lineItems;
        private List<LineItem> payableLineItem;

        CalcDetailBuilder() {
        }

        @JsonProperty(value="id")
        public CalcDetailBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="billId")
        public CalcDetailBuilder billId(String billId) {
            this.billId = billId;
            return this;
        }

        @JsonProperty(value="referenceId")
        public CalcDetailBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="fromPeriod")
        public CalcDetailBuilder fromPeriod(BigDecimal fromPeriod) {
            this.fromPeriod = fromPeriod;
            return this;
        }

        @JsonProperty(value="toPeriod")
        public CalcDetailBuilder toPeriod(BigDecimal toPeriod) {
            this.toPeriod = toPeriod;
            return this;
        }

        @JsonProperty(value="payee")
        public CalcDetailBuilder payee(Party payee) {
            this.payee = payee;
            return this;
        }

        @JsonProperty(value="lineItems")
        public CalcDetailBuilder lineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        @JsonProperty(value="payableLineItem")
        public CalcDetailBuilder payableLineItem(List<LineItem> payableLineItem) {
            this.payableLineItem = payableLineItem;
            return this;
        }

        public CalcDetail build() {
            return new CalcDetail(this.id, this.billId, this.referenceId, this.fromPeriod, this.toPeriod, this.payee, this.lineItems, this.payableLineItem);
        }

        public String toString() {
            return "CalcDetail.CalcDetailBuilder(id=" + this.id + ", billId=" + this.billId + ", referenceId=" + this.referenceId + ", fromPeriod=" + this.fromPeriod + ", toPeriod=" + this.toPeriod + ", payee=" + this.payee + ", lineItems=" + this.lineItems + ", payableLineItem=" + this.payableLineItem + ")";
        }
    }
}

