/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.expense.Pagination;
import org.egov.works.services.common.models.expense.Payment;

public class PaymentResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo;
    @JsonProperty(value="payments")
    @Valid
    private List<Payment> payments;
    @JsonProperty(value="pagination")
    private Pagination pagination;

    public PaymentResponse addPaymentItem(Payment paymentItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentItem);
        return this;
    }

    public static PaymentResponseBuilder builder() {
        return new PaymentResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Payment> getPayments() {
        return this.payments;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="payments")
    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    @JsonProperty(value="pagination")
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentResponse)) {
            return false;
        }
        PaymentResponse other = (PaymentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Payment> this$payments = this.getPayments();
        List<Payment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Payment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentResponse(responseInfo=" + this.getResponseInfo() + ", payments=" + this.getPayments() + ", pagination=" + this.getPagination() + ")";
    }

    public PaymentResponse(ResponseInfo responseInfo, List<Payment> payments, Pagination pagination) {
        this.responseInfo = responseInfo;
        this.payments = payments;
        this.pagination = pagination;
    }

    public PaymentResponse() {
    }

    public static class PaymentResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Payment> payments;
        private Pagination pagination;

        PaymentResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public PaymentResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="payments")
        public PaymentResponseBuilder payments(List<Payment> payments) {
            this.payments = payments;
            return this;
        }

        @JsonProperty(value="pagination")
        public PaymentResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public PaymentResponse build() {
            return new PaymentResponse(this.responseInfo, this.payments, this.pagination);
        }

        public String toString() {
            return "PaymentResponse.PaymentResponseBuilder(responseInfo=" + this.responseInfo + ", payments=" + this.payments + ", pagination=" + this.pagination + ")";
        }
    }
}

