/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;
import org.springframework.validation.annotation.Validated;

@Validated
public class PaymentLineItem {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="lineItemId")
    private String lineItemId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="paidAmount")
    @NotNull
    private BigDecimal paidAmount;
    @JsonProperty(value="status")
    private PaymentStatus status;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;

    public static PaymentLineItemBuilder builder() {
        return new PaymentLineItemBuilder();
    }

    public PaymentLineItem(String id, String lineItemId, String tenantId, BigDecimal paidAmount, PaymentStatus status, AuditDetails auditDetails) {
        this.id = id;
        this.lineItemId = lineItemId;
        this.tenantId = tenantId;
        this.paidAmount = paidAmount;
        this.status = status;
        this.auditDetails = auditDetails;
    }

    public PaymentLineItem() {
    }

    public String getId() {
        return this.id;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public BigDecimal getPaidAmount() {
        return this.paidAmount;
    }

    public PaymentStatus getStatus() {
        return this.status;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="lineItemId")
    public void setLineItemId(String lineItemId) {
        this.lineItemId = lineItemId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="paidAmount")
    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    @JsonProperty(value="status")
    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentLineItem)) {
            return false;
        }
        PaymentLineItem other = (PaymentLineItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lineItemId = this.getLineItemId();
        String other$lineItemId = other.getLineItemId();
        if (this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        BigDecimal this$paidAmount = this.getPaidAmount();
        BigDecimal other$paidAmount = other.getPaidAmount();
        if (this$paidAmount == null ? other$paidAmount != null : !((Object)this$paidAmount).equals(other$paidAmount)) {
            return false;
        }
        PaymentStatus this$status = this.getStatus();
        PaymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentLineItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lineItemId = this.getLineItemId();
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        BigDecimal $paidAmount = this.getPaidAmount();
        result = result * 59 + ($paidAmount == null ? 43 : ((Object)$paidAmount).hashCode());
        PaymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentLineItem(id=" + this.getId() + ", lineItemId=" + this.getLineItemId() + ", tenantId=" + this.getTenantId() + ", paidAmount=" + this.getPaidAmount() + ", status=" + this.getStatus() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public static class PaymentLineItemBuilder {
        private String id;
        private String lineItemId;
        private String tenantId;
        private BigDecimal paidAmount;
        private PaymentStatus status;
        private AuditDetails auditDetails;

        PaymentLineItemBuilder() {
        }

        @JsonProperty(value="id")
        public PaymentLineItemBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="lineItemId")
        public PaymentLineItemBuilder lineItemId(String lineItemId) {
            this.lineItemId = lineItemId;
            return this;
        }

        @JsonProperty(value="tenantId")
        public PaymentLineItemBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="paidAmount")
        public PaymentLineItemBuilder paidAmount(BigDecimal paidAmount) {
            this.paidAmount = paidAmount;
            return this;
        }

        @JsonProperty(value="status")
        public PaymentLineItemBuilder status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public PaymentLineItemBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public PaymentLineItem build() {
            return new PaymentLineItem(this.id, this.lineItemId, this.tenantId, this.paidAmount, this.status, this.auditDetails);
        }

        public String toString() {
            return "PaymentLineItem.PaymentLineItemBuilder(id=" + this.id + ", lineItemId=" + this.lineItemId + ", tenantId=" + this.tenantId + ", paidAmount=" + this.paidAmount + ", status=" + this.status + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

