/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.PaymentLineItem;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;
import org.springframework.validation.annotation.Validated;

@Validated
public class PaymentBillDetail {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="billDetailId")
    @NotNull
    private String billDetailId;
    @JsonProperty(value="totalAmount")
    private BigDecimal totalAmount;
    @JsonProperty(value="totalPaidAmount")
    private BigDecimal totalPaidAmount;
    @JsonProperty(value="status")
    private PaymentStatus status;
    @JsonProperty(value="payableLineItems")
    @Valid
    @NotNull
    private List<PaymentLineItem> payableLineItems;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;

    public PaymentBillDetail addLineItem(PaymentLineItem paymentLineItem) {
        if (null == this.payableLineItems) {
            this.payableLineItems = new ArrayList<PaymentLineItem>();
        }
        this.payableLineItems.add(paymentLineItem);
        return this;
    }

    private static BigDecimal $default$totalPaidAmount() {
        return BigDecimal.ZERO;
    }

    public static PaymentBillDetailBuilder builder() {
        return new PaymentBillDetailBuilder();
    }

    public PaymentBillDetail(String id, String tenantId, String billDetailId, BigDecimal totalAmount, BigDecimal totalPaidAmount, PaymentStatus status, List<PaymentLineItem> payableLineItems, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.billDetailId = billDetailId;
        this.totalAmount = totalAmount;
        this.totalPaidAmount = totalPaidAmount;
        this.status = status;
        this.payableLineItems = payableLineItems;
        this.auditDetails = auditDetails;
    }

    public PaymentBillDetail() {
        this.totalPaidAmount = PaymentBillDetail.$default$totalPaidAmount();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getBillDetailId() {
        return this.billDetailId;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getTotalPaidAmount() {
        return this.totalPaidAmount;
    }

    public PaymentStatus getStatus() {
        return this.status;
    }

    public List<PaymentLineItem> getPayableLineItems() {
        return this.payableLineItems;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="billDetailId")
    public void setBillDetailId(String billDetailId) {
        this.billDetailId = billDetailId;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="totalPaidAmount")
    public void setTotalPaidAmount(BigDecimal totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    @JsonProperty(value="status")
    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    @JsonProperty(value="payableLineItems")
    public void setPayableLineItems(List<PaymentLineItem> payableLineItems) {
        this.payableLineItems = payableLineItems;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentBillDetail)) {
            return false;
        }
        PaymentBillDetail other = (PaymentBillDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$billDetailId = this.getBillDetailId();
        String other$billDetailId = other.getBillDetailId();
        if (this$billDetailId == null ? other$billDetailId != null : !this$billDetailId.equals(other$billDetailId)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$totalPaidAmount = this.getTotalPaidAmount();
        BigDecimal other$totalPaidAmount = other.getTotalPaidAmount();
        if (this$totalPaidAmount == null ? other$totalPaidAmount != null : !((Object)this$totalPaidAmount).equals(other$totalPaidAmount)) {
            return false;
        }
        PaymentStatus this$status = this.getStatus();
        PaymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<PaymentLineItem> this$payableLineItems = this.getPayableLineItems();
        List<PaymentLineItem> other$payableLineItems = other.getPayableLineItems();
        if (this$payableLineItems == null ? other$payableLineItems != null : !((Object)this$payableLineItems).equals(other$payableLineItems)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentBillDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $billDetailId = this.getBillDetailId();
        result = result * 59 + ($billDetailId == null ? 43 : $billDetailId.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $totalPaidAmount = this.getTotalPaidAmount();
        result = result * 59 + ($totalPaidAmount == null ? 43 : ((Object)$totalPaidAmount).hashCode());
        PaymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<PaymentLineItem> $payableLineItems = this.getPayableLineItems();
        result = result * 59 + ($payableLineItems == null ? 43 : ((Object)$payableLineItems).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentBillDetail(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", billDetailId=" + this.getBillDetailId() + ", totalAmount=" + this.getTotalAmount() + ", totalPaidAmount=" + this.getTotalPaidAmount() + ", status=" + this.getStatus() + ", payableLineItems=" + this.getPayableLineItems() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public static class PaymentBillDetailBuilder {
        private String id;
        private String tenantId;
        private String billDetailId;
        private BigDecimal totalAmount;
        private boolean totalPaidAmount$set;
        private BigDecimal totalPaidAmount$value;
        private PaymentStatus status;
        private List<PaymentLineItem> payableLineItems;
        private AuditDetails auditDetails;

        PaymentBillDetailBuilder() {
        }

        @JsonProperty(value="id")
        public PaymentBillDetailBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public PaymentBillDetailBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="billDetailId")
        public PaymentBillDetailBuilder billDetailId(String billDetailId) {
            this.billDetailId = billDetailId;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public PaymentBillDetailBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @JsonProperty(value="totalPaidAmount")
        public PaymentBillDetailBuilder totalPaidAmount(BigDecimal totalPaidAmount) {
            this.totalPaidAmount$value = totalPaidAmount;
            this.totalPaidAmount$set = true;
            return this;
        }

        @JsonProperty(value="status")
        public PaymentBillDetailBuilder status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="payableLineItems")
        public PaymentBillDetailBuilder payableLineItems(List<PaymentLineItem> payableLineItems) {
            this.payableLineItems = payableLineItems;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public PaymentBillDetailBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public PaymentBillDetail build() {
            BigDecimal totalPaidAmount$value = this.totalPaidAmount$value;
            if (!this.totalPaidAmount$set) {
                totalPaidAmount$value = PaymentBillDetail.$default$totalPaidAmount();
            }
            return new PaymentBillDetail(this.id, this.tenantId, this.billDetailId, this.totalAmount, totalPaidAmount$value, this.status, this.payableLineItems, this.auditDetails);
        }

        public String toString() {
            return "PaymentBillDetail.PaymentBillDetailBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", billDetailId=" + this.billDetailId + ", totalAmount=" + this.totalAmount + ", totalPaidAmount$value=" + this.totalPaidAmount$value + ", status=" + this.status + ", payableLineItems=" + this.payableLineItems + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

