/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.PaymentBillDetail;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;

public class PaymentBill {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="billId")
    @NotNull
    private String billId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="totalAmount")
    private BigDecimal totalAmount;
    @JsonProperty(value="totalPaidAmount")
    private BigDecimal totalPaidAmount;
    @JsonProperty(value="status")
    private PaymentStatus status;
    @JsonProperty(value="billDetails")
    @Valid
    @NotNull
    private List<PaymentBillDetail> billDetails;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;

    public PaymentBill addPaymentBillDetailItem(PaymentBillDetail paymentBillDetailItem) {
        if (null == this.billDetails) {
            this.billDetails = new ArrayList<PaymentBillDetail>();
        }
        this.billDetails.add(paymentBillDetailItem);
        return this;
    }

    private static BigDecimal $default$totalPaidAmount() {
        return BigDecimal.ZERO;
    }

    public static PaymentBillBuilder builder() {
        return new PaymentBillBuilder();
    }

    public PaymentBill(String id, String billId, String tenantId, BigDecimal totalAmount, BigDecimal totalPaidAmount, PaymentStatus status, List<PaymentBillDetail> billDetails, AuditDetails auditDetails) {
        this.id = id;
        this.billId = billId;
        this.tenantId = tenantId;
        this.totalAmount = totalAmount;
        this.totalPaidAmount = totalPaidAmount;
        this.status = status;
        this.billDetails = billDetails;
        this.auditDetails = auditDetails;
    }

    public PaymentBill() {
        this.totalPaidAmount = PaymentBill.$default$totalPaidAmount();
    }

    public String getId() {
        return this.id;
    }

    public String getBillId() {
        return this.billId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getTotalPaidAmount() {
        return this.totalPaidAmount;
    }

    public PaymentStatus getStatus() {
        return this.status;
    }

    public List<PaymentBillDetail> getBillDetails() {
        return this.billDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="billId")
    public void setBillId(String billId) {
        this.billId = billId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="totalPaidAmount")
    public void setTotalPaidAmount(BigDecimal totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    @JsonProperty(value="status")
    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    @JsonProperty(value="billDetails")
    public void setBillDetails(List<PaymentBillDetail> billDetails) {
        this.billDetails = billDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentBill)) {
            return false;
        }
        PaymentBill other = (PaymentBill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$billId = this.getBillId();
        String other$billId = other.getBillId();
        if (this$billId == null ? other$billId != null : !this$billId.equals(other$billId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$totalPaidAmount = this.getTotalPaidAmount();
        BigDecimal other$totalPaidAmount = other.getTotalPaidAmount();
        if (this$totalPaidAmount == null ? other$totalPaidAmount != null : !((Object)this$totalPaidAmount).equals(other$totalPaidAmount)) {
            return false;
        }
        PaymentStatus this$status = this.getStatus();
        PaymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<PaymentBillDetail> this$billDetails = this.getBillDetails();
        List<PaymentBillDetail> other$billDetails = other.getBillDetails();
        if (this$billDetails == null ? other$billDetails != null : !((Object)this$billDetails).equals(other$billDetails)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentBill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $billId = this.getBillId();
        result = result * 59 + ($billId == null ? 43 : $billId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $totalPaidAmount = this.getTotalPaidAmount();
        result = result * 59 + ($totalPaidAmount == null ? 43 : ((Object)$totalPaidAmount).hashCode());
        PaymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<PaymentBillDetail> $billDetails = this.getBillDetails();
        result = result * 59 + ($billDetails == null ? 43 : ((Object)$billDetails).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentBill(id=" + this.getId() + ", billId=" + this.getBillId() + ", tenantId=" + this.getTenantId() + ", totalAmount=" + this.getTotalAmount() + ", totalPaidAmount=" + this.getTotalPaidAmount() + ", status=" + this.getStatus() + ", billDetails=" + this.getBillDetails() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public static class PaymentBillBuilder {
        private String id;
        private String billId;
        private String tenantId;
        private BigDecimal totalAmount;
        private boolean totalPaidAmount$set;
        private BigDecimal totalPaidAmount$value;
        private PaymentStatus status;
        private List<PaymentBillDetail> billDetails;
        private AuditDetails auditDetails;

        PaymentBillBuilder() {
        }

        @JsonProperty(value="id")
        public PaymentBillBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="billId")
        public PaymentBillBuilder billId(String billId) {
            this.billId = billId;
            return this;
        }

        @JsonProperty(value="tenantId")
        public PaymentBillBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public PaymentBillBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        @JsonProperty(value="totalPaidAmount")
        public PaymentBillBuilder totalPaidAmount(BigDecimal totalPaidAmount) {
            this.totalPaidAmount$value = totalPaidAmount;
            this.totalPaidAmount$set = true;
            return this;
        }

        @JsonProperty(value="status")
        public PaymentBillBuilder status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="billDetails")
        public PaymentBillBuilder billDetails(List<PaymentBillDetail> billDetails) {
            this.billDetails = billDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public PaymentBillBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public PaymentBill build() {
            BigDecimal totalPaidAmount$value = this.totalPaidAmount$value;
            if (!this.totalPaidAmount$set) {
                totalPaidAmount$value = PaymentBill.$default$totalPaidAmount();
            }
            return new PaymentBill(this.id, this.billId, this.tenantId, this.totalAmount, totalPaidAmount$value, this.status, this.billDetails, this.auditDetails);
        }

        public String toString() {
            return "PaymentBill.PaymentBillBuilder(id=" + this.id + ", billId=" + this.billId + ", tenantId=" + this.tenantId + ", totalAmount=" + this.totalAmount + ", totalPaidAmount$value=" + this.totalPaidAmount$value + ", status=" + this.status + ", billDetails=" + this.billDetails + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

