/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.PaymentBill;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;
import org.egov.works.services.common.models.expense.enums.ReferenceStatus;

public class Payment {
    @JsonProperty(value="tenantId")
    @NotNull
    private String tenantId;
    @JsonProperty(value="id")
    @Valid
    private String id;
    @JsonProperty(value="netPayableAmount")
    @NotNull
    private BigDecimal netPayableAmount;
    @JsonProperty(value="netPaidAmount")
    @NotNull
    private BigDecimal netPaidAmount;
    @JsonProperty(value="bills")
    @Valid
    @NotNull
    private List<PaymentBill> bills;
    @JsonProperty(value="paymentNumber")
    private String paymentNumber;
    @JsonProperty(value="status")
    private PaymentStatus status;
    @JsonProperty(value="referenceStatus")
    private ReferenceStatus referenceStatus;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails;

    public Payment addBillItem(PaymentBill bill) {
        if (this.bills == null) {
            this.bills = new ArrayList<PaymentBill>();
        }
        this.bills.add(bill);
        return this;
    }

    public static PaymentBuilder builder() {
        return new PaymentBuilder();
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getNetPayableAmount() {
        return this.netPayableAmount;
    }

    public BigDecimal getNetPaidAmount() {
        return this.netPaidAmount;
    }

    public List<PaymentBill> getBills() {
        return this.bills;
    }

    public String getPaymentNumber() {
        return this.paymentNumber;
    }

    public PaymentStatus getStatus() {
        return this.status;
    }

    public ReferenceStatus getReferenceStatus() {
        return this.referenceStatus;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="netPayableAmount")
    public void setNetPayableAmount(BigDecimal netPayableAmount) {
        this.netPayableAmount = netPayableAmount;
    }

    @JsonProperty(value="netPaidAmount")
    public void setNetPaidAmount(BigDecimal netPaidAmount) {
        this.netPaidAmount = netPaidAmount;
    }

    @JsonProperty(value="bills")
    public void setBills(List<PaymentBill> bills) {
        this.bills = bills;
    }

    @JsonProperty(value="paymentNumber")
    public void setPaymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    @JsonProperty(value="status")
    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    @JsonProperty(value="referenceStatus")
    public void setReferenceStatus(ReferenceStatus referenceStatus) {
        this.referenceStatus = referenceStatus;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        BigDecimal this$netPayableAmount = this.getNetPayableAmount();
        BigDecimal other$netPayableAmount = other.getNetPayableAmount();
        if (this$netPayableAmount == null ? other$netPayableAmount != null : !((Object)this$netPayableAmount).equals(other$netPayableAmount)) {
            return false;
        }
        BigDecimal this$netPaidAmount = this.getNetPaidAmount();
        BigDecimal other$netPaidAmount = other.getNetPaidAmount();
        if (this$netPaidAmount == null ? other$netPaidAmount != null : !((Object)this$netPaidAmount).equals(other$netPaidAmount)) {
            return false;
        }
        List<PaymentBill> this$bills = this.getBills();
        List<PaymentBill> other$bills = other.getBills();
        if (this$bills == null ? other$bills != null : !((Object)this$bills).equals(other$bills)) {
            return false;
        }
        String this$paymentNumber = this.getPaymentNumber();
        String other$paymentNumber = other.getPaymentNumber();
        if (this$paymentNumber == null ? other$paymentNumber != null : !this$paymentNumber.equals(other$paymentNumber)) {
            return false;
        }
        PaymentStatus this$status = this.getStatus();
        PaymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ReferenceStatus this$referenceStatus = this.getReferenceStatus();
        ReferenceStatus other$referenceStatus = other.getReferenceStatus();
        if (this$referenceStatus == null ? other$referenceStatus != null : !((Object)((Object)this$referenceStatus)).equals((Object)other$referenceStatus)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        BigDecimal $netPayableAmount = this.getNetPayableAmount();
        result = result * 59 + ($netPayableAmount == null ? 43 : ((Object)$netPayableAmount).hashCode());
        BigDecimal $netPaidAmount = this.getNetPaidAmount();
        result = result * 59 + ($netPaidAmount == null ? 43 : ((Object)$netPaidAmount).hashCode());
        List<PaymentBill> $bills = this.getBills();
        result = result * 59 + ($bills == null ? 43 : ((Object)$bills).hashCode());
        String $paymentNumber = this.getPaymentNumber();
        result = result * 59 + ($paymentNumber == null ? 43 : $paymentNumber.hashCode());
        PaymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ReferenceStatus $referenceStatus = this.getReferenceStatus();
        result = result * 59 + ($referenceStatus == null ? 43 : ((Object)((Object)$referenceStatus)).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Payment(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", netPayableAmount=" + this.getNetPayableAmount() + ", netPaidAmount=" + this.getNetPaidAmount() + ", bills=" + this.getBills() + ", paymentNumber=" + this.getPaymentNumber() + ", status=" + this.getStatus() + ", referenceStatus=" + this.getReferenceStatus() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ")";
    }

    public Payment(String tenantId, String id, BigDecimal netPayableAmount, BigDecimal netPaidAmount, List<PaymentBill> bills, String paymentNumber, PaymentStatus status, ReferenceStatus referenceStatus, AuditDetails auditDetails, Object additionalDetails) {
        this.tenantId = tenantId;
        this.id = id;
        this.netPayableAmount = netPayableAmount;
        this.netPaidAmount = netPaidAmount;
        this.bills = bills;
        this.paymentNumber = paymentNumber;
        this.status = status;
        this.referenceStatus = referenceStatus;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public Payment() {
    }

    public static class PaymentBuilder {
        private String tenantId;
        private String id;
        private BigDecimal netPayableAmount;
        private BigDecimal netPaidAmount;
        private List<PaymentBill> bills;
        private String paymentNumber;
        private PaymentStatus status;
        private ReferenceStatus referenceStatus;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        PaymentBuilder() {
        }

        @JsonProperty(value="tenantId")
        public PaymentBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="id")
        public PaymentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="netPayableAmount")
        public PaymentBuilder netPayableAmount(BigDecimal netPayableAmount) {
            this.netPayableAmount = netPayableAmount;
            return this;
        }

        @JsonProperty(value="netPaidAmount")
        public PaymentBuilder netPaidAmount(BigDecimal netPaidAmount) {
            this.netPaidAmount = netPaidAmount;
            return this;
        }

        @JsonProperty(value="bills")
        public PaymentBuilder bills(List<PaymentBill> bills) {
            this.bills = bills;
            return this;
        }

        @JsonProperty(value="paymentNumber")
        public PaymentBuilder paymentNumber(String paymentNumber) {
            this.paymentNumber = paymentNumber;
            return this;
        }

        @JsonProperty(value="status")
        public PaymentBuilder status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="referenceStatus")
        public PaymentBuilder referenceStatus(ReferenceStatus referenceStatus) {
            this.referenceStatus = referenceStatus;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public PaymentBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public PaymentBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public Payment build() {
            return new Payment(this.tenantId, this.id, this.netPayableAmount, this.netPaidAmount, this.bills, this.paymentNumber, this.status, this.referenceStatus, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "Payment.PaymentBuilder(tenantId=" + this.tenantId + ", id=" + this.id + ", netPayableAmount=" + this.netPayableAmount + ", netPaidAmount=" + this.netPaidAmount + ", bills=" + this.bills + ", paymentNumber=" + this.paymentNumber + ", status=" + this.status + ", referenceStatus=" + this.referenceStatus + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

