/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.expense.Bill;
import org.egov.works.services.common.models.expense.Pagination;

public class BillResponse {
    @JsonProperty(value="ResponseInfo")
    @Valid
    private ResponseInfo responseInfo;
    @JsonProperty(value="bills")
    @Valid
    private List<Bill> bills;
    @JsonProperty(value="pagination")
    @Valid
    private Pagination pagination;

    public BillResponse addBillItem(Bill billItem) {
        if (this.bills == null) {
            this.bills = new ArrayList<Bill>();
        }
        this.bills.add(billItem);
        return this;
    }

    public static BillResponseBuilder builder() {
        return new BillResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Bill> getBills() {
        return this.bills;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="bills")
    public void setBills(List<Bill> bills) {
        this.bills = bills;
    }

    @JsonProperty(value="pagination")
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillResponse)) {
            return false;
        }
        BillResponse other = (BillResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Bill> this$bills = this.getBills();
        List<Bill> other$bills = other.getBills();
        if (this$bills == null ? other$bills != null : !((Object)this$bills).equals(other$bills)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BillResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Bill> $bills = this.getBills();
        result = result * 59 + ($bills == null ? 43 : ((Object)$bills).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public String toString() {
        return "BillResponse(responseInfo=" + this.getResponseInfo() + ", bills=" + this.getBills() + ", pagination=" + this.getPagination() + ")";
    }

    public BillResponse(ResponseInfo responseInfo, List<Bill> bills, Pagination pagination) {
        this.responseInfo = responseInfo;
        this.bills = bills;
        this.pagination = pagination;
    }

    public BillResponse() {
    }

    public static class BillResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Bill> bills;
        private Pagination pagination;

        BillResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public BillResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="bills")
        public BillResponseBuilder bills(List<Bill> bills) {
            this.bills = bills;
            return this;
        }

        @JsonProperty(value="pagination")
        public BillResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public BillResponse build() {
            return new BillResponse(this.responseInfo, this.bills, this.pagination);
        }

        public String toString() {
            return "BillResponse.BillResponseBuilder(responseInfo=" + this.responseInfo + ", bills=" + this.bills + ", pagination=" + this.pagination + ")";
        }
    }
}

