/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.LineItem;
import org.egov.works.services.common.models.expense.Party;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;
import org.egov.works.services.common.models.expense.enums.Status;

public class BillDetail {
    @JsonProperty(value="id")
    @Valid
    private String id;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId;
    @JsonProperty(value="billId")
    @Valid
    private String billId;
    @JsonProperty(value="totalAmount")
    @Valid
    private BigDecimal totalAmount;
    @JsonProperty(value="totalPaidAmount")
    @Valid
    private BigDecimal totalPaidAmount;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceId;
    @JsonProperty(value="paymentStatus")
    private PaymentStatus paymentStatus;
    @JsonProperty(value="status")
    private Status status;
    @JsonProperty(value="fromPeriod")
    @Valid
    private Long fromPeriod;
    @JsonProperty(value="toPeriod")
    @Valid
    private Long toPeriod;
    @JsonProperty(value="payee")
    @NotNull
    @Valid
    private Party payee;
    @JsonProperty(value="lineItems")
    @Valid
    private List<LineItem> lineItems;
    @JsonProperty(value="payableLineItems")
    @NotNull
    @Valid
    private List<LineItem> payableLineItems;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails;

    public BillDetail addLineItems(LineItem lineItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItem);
        return this;
    }

    public BillDetail addPayableLineItems(LineItem payableLineItem) {
        if (this.payableLineItems == null) {
            this.payableLineItems = new ArrayList<LineItem>();
        }
        this.payableLineItems.add(payableLineItem);
        return this;
    }

    private static BigDecimal $default$totalAmount() {
        return BigDecimal.ZERO;
    }

    private static BigDecimal $default$totalPaidAmount() {
        return BigDecimal.ZERO;
    }

    public static BillDetailBuilder builder() {
        return new BillDetailBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getBillId() {
        return this.billId;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getTotalPaidAmount() {
        return this.totalPaidAmount;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public Long getFromPeriod() {
        return this.fromPeriod;
    }

    public Long getToPeriod() {
        return this.toPeriod;
    }

    public Party getPayee() {
        return this.payee;
    }

    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public List<LineItem> getPayableLineItems() {
        return this.payableLineItems;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="billId")
    public void setBillId(String billId) {
        this.billId = billId;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="totalPaidAmount")
    public void setTotalPaidAmount(BigDecimal totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="paymentStatus")
    public void setPaymentStatus(PaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="fromPeriod")
    public void setFromPeriod(Long fromPeriod) {
        this.fromPeriod = fromPeriod;
    }

    @JsonProperty(value="toPeriod")
    public void setToPeriod(Long toPeriod) {
        this.toPeriod = toPeriod;
    }

    @JsonProperty(value="payee")
    public void setPayee(Party payee) {
        this.payee = payee;
    }

    @JsonProperty(value="lineItems")
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    @JsonProperty(value="payableLineItems")
    public void setPayableLineItems(List<LineItem> payableLineItems) {
        this.payableLineItems = payableLineItems;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillDetail)) {
            return false;
        }
        BillDetail other = (BillDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fromPeriod = this.getFromPeriod();
        Long other$fromPeriod = other.getFromPeriod();
        if (this$fromPeriod == null ? other$fromPeriod != null : !((Object)this$fromPeriod).equals(other$fromPeriod)) {
            return false;
        }
        Long this$toPeriod = this.getToPeriod();
        Long other$toPeriod = other.getToPeriod();
        if (this$toPeriod == null ? other$toPeriod != null : !((Object)this$toPeriod).equals(other$toPeriod)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$billId = this.getBillId();
        String other$billId = other.getBillId();
        if (this$billId == null ? other$billId != null : !this$billId.equals(other$billId)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$totalPaidAmount = this.getTotalPaidAmount();
        BigDecimal other$totalPaidAmount = other.getTotalPaidAmount();
        if (this$totalPaidAmount == null ? other$totalPaidAmount != null : !((Object)this$totalPaidAmount).equals(other$totalPaidAmount)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        PaymentStatus this$paymentStatus = this.getPaymentStatus();
        PaymentStatus other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !((Object)((Object)this$paymentStatus)).equals((Object)other$paymentStatus)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Party this$payee = this.getPayee();
        Party other$payee = other.getPayee();
        if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
            return false;
        }
        List<LineItem> this$lineItems = this.getLineItems();
        List<LineItem> other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        List<LineItem> this$payableLineItems = this.getPayableLineItems();
        List<LineItem> other$payableLineItems = other.getPayableLineItems();
        if (this$payableLineItems == null ? other$payableLineItems != null : !((Object)this$payableLineItems).equals(other$payableLineItems)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BillDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fromPeriod = this.getFromPeriod();
        result = result * 59 + ($fromPeriod == null ? 43 : ((Object)$fromPeriod).hashCode());
        Long $toPeriod = this.getToPeriod();
        result = result * 59 + ($toPeriod == null ? 43 : ((Object)$toPeriod).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $billId = this.getBillId();
        result = result * 59 + ($billId == null ? 43 : $billId.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $totalPaidAmount = this.getTotalPaidAmount();
        result = result * 59 + ($totalPaidAmount == null ? 43 : ((Object)$totalPaidAmount).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        PaymentStatus $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : ((Object)((Object)$paymentStatus)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Party $payee = this.getPayee();
        result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
        List<LineItem> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        List<LineItem> $payableLineItems = this.getPayableLineItems();
        result = result * 59 + ($payableLineItems == null ? 43 : ((Object)$payableLineItems).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    public String toString() {
        return "BillDetail(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", billId=" + this.getBillId() + ", totalAmount=" + this.getTotalAmount() + ", totalPaidAmount=" + this.getTotalPaidAmount() + ", referenceId=" + this.getReferenceId() + ", paymentStatus=" + this.getPaymentStatus() + ", status=" + this.getStatus() + ", fromPeriod=" + this.getFromPeriod() + ", toPeriod=" + this.getToPeriod() + ", payee=" + this.getPayee() + ", lineItems=" + this.getLineItems() + ", payableLineItems=" + this.getPayableLineItems() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ")";
    }

    public BillDetail(String id, String tenantId, String billId, BigDecimal totalAmount, BigDecimal totalPaidAmount, String referenceId, PaymentStatus paymentStatus, Status status, Long fromPeriod, Long toPeriod, Party payee, List<LineItem> lineItems, List<LineItem> payableLineItems, AuditDetails auditDetails, Object additionalDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.billId = billId;
        this.totalAmount = totalAmount;
        this.totalPaidAmount = totalPaidAmount;
        this.referenceId = referenceId;
        this.paymentStatus = paymentStatus;
        this.status = status;
        this.fromPeriod = fromPeriod;
        this.toPeriod = toPeriod;
        this.payee = payee;
        this.lineItems = lineItems;
        this.payableLineItems = payableLineItems;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public BillDetail() {
        this.totalAmount = BillDetail.$default$totalAmount();
        this.totalPaidAmount = BillDetail.$default$totalPaidAmount();
    }

    public static class BillDetailBuilder {
        private String id;
        private String tenantId;
        private String billId;
        private boolean totalAmount$set;
        private BigDecimal totalAmount$value;
        private boolean totalPaidAmount$set;
        private BigDecimal totalPaidAmount$value;
        private String referenceId;
        private PaymentStatus paymentStatus;
        private Status status;
        private Long fromPeriod;
        private Long toPeriod;
        private Party payee;
        private List<LineItem> lineItems;
        private List<LineItem> payableLineItems;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        BillDetailBuilder() {
        }

        @JsonProperty(value="id")
        public BillDetailBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public BillDetailBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="billId")
        public BillDetailBuilder billId(String billId) {
            this.billId = billId;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public BillDetailBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount$value = totalAmount;
            this.totalAmount$set = true;
            return this;
        }

        @JsonProperty(value="totalPaidAmount")
        public BillDetailBuilder totalPaidAmount(BigDecimal totalPaidAmount) {
            this.totalPaidAmount$value = totalPaidAmount;
            this.totalPaidAmount$set = true;
            return this;
        }

        @JsonProperty(value="referenceId")
        public BillDetailBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="paymentStatus")
        public BillDetailBuilder paymentStatus(PaymentStatus paymentStatus) {
            this.paymentStatus = paymentStatus;
            return this;
        }

        @JsonProperty(value="status")
        public BillDetailBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="fromPeriod")
        public BillDetailBuilder fromPeriod(Long fromPeriod) {
            this.fromPeriod = fromPeriod;
            return this;
        }

        @JsonProperty(value="toPeriod")
        public BillDetailBuilder toPeriod(Long toPeriod) {
            this.toPeriod = toPeriod;
            return this;
        }

        @JsonProperty(value="payee")
        public BillDetailBuilder payee(Party payee) {
            this.payee = payee;
            return this;
        }

        @JsonProperty(value="lineItems")
        public BillDetailBuilder lineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        @JsonProperty(value="payableLineItems")
        public BillDetailBuilder payableLineItems(List<LineItem> payableLineItems) {
            this.payableLineItems = payableLineItems;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BillDetailBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public BillDetailBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public BillDetail build() {
            BigDecimal totalAmount$value = this.totalAmount$value;
            if (!this.totalAmount$set) {
                totalAmount$value = BillDetail.$default$totalAmount();
            }
            BigDecimal totalPaidAmount$value = this.totalPaidAmount$value;
            if (!this.totalPaidAmount$set) {
                totalPaidAmount$value = BillDetail.$default$totalPaidAmount();
            }
            return new BillDetail(this.id, this.tenantId, this.billId, totalAmount$value, totalPaidAmount$value, this.referenceId, this.paymentStatus, this.status, this.fromPeriod, this.toPeriod, this.payee, this.lineItems, this.payableLineItems, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "BillDetail.BillDetailBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", billId=" + this.billId + ", totalAmount$value=" + this.totalAmount$value + ", totalPaidAmount$value=" + this.totalPaidAmount$value + ", referenceId=" + this.referenceId + ", paymentStatus=" + this.paymentStatus + ", status=" + this.status + ", fromPeriod=" + this.fromPeriod + ", toPeriod=" + this.toPeriod + ", payee=" + this.payee + ", lineItems=" + this.lineItems + ", payableLineItems=" + this.payableLineItems + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

