/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.expense;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.expense.BillDetail;
import org.egov.works.services.common.models.expense.Party;
import org.egov.works.services.common.models.expense.enums.PaymentStatus;
import org.egov.works.services.common.models.expense.enums.Status;

public class Bill {
    @JsonProperty(value="id")
    @Valid
    private String id;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId;
    @JsonProperty(value="billDate")
    @Valid
    @NotNull
    private Long billDate;
    @JsonProperty(value="dueDate")
    @Valid
    private Long dueDate;
    @JsonProperty(value="totalAmount")
    @Valid
    private BigDecimal totalAmount;
    @JsonProperty(value="totalPaidAmount")
    @Valid
    private BigDecimal totalPaidAmount;
    @JsonProperty(value="businessService")
    @NotNull
    @Size(min=2, max=128)
    private @NotNull @Size(min=2, max=128) String businessService;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=128)
    @NotNull
    private @Size(min=2, max=128) @NotNull String referenceId;
    @JsonProperty(value="fromPeriod")
    @Valid
    private Long fromPeriod;
    @JsonProperty(value="toPeriod")
    @Valid
    private Long toPeriod;
    @JsonProperty(value="paymentStatus")
    private PaymentStatus paymentStatus;
    @JsonProperty(value="status")
    private Status status;
    @JsonProperty(value="billNumber")
    private String billNumber;
    @JsonProperty(value="payer")
    @NotNull
    @Valid
    private Party payer;
    @JsonProperty(value="billDetails")
    @NotNull
    @Valid
    private List<BillDetail> billDetails;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails;
    @JsonProperty(value="wfStatus")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String wfStatus;

    public Bill addBillDetailsItem(BillDetail billDetailsItem) {
        if (null == this.billDetails) {
            this.billDetails = new ArrayList<BillDetail>();
        }
        this.billDetails.add(billDetailsItem);
        return this;
    }

    private static BigDecimal $default$totalAmount() {
        return BigDecimal.ZERO;
    }

    private static BigDecimal $default$totalPaidAmount() {
        return BigDecimal.ZERO;
    }

    public static BillBuilder builder() {
        return new BillBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Long getBillDate() {
        return this.billDate;
    }

    public Long getDueDate() {
        return this.dueDate;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getTotalPaidAmount() {
        return this.totalPaidAmount;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public Long getFromPeriod() {
        return this.fromPeriod;
    }

    public Long getToPeriod() {
        return this.toPeriod;
    }

    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public Party getPayer() {
        return this.payer;
    }

    public List<BillDetail> getBillDetails() {
        return this.billDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public String getWfStatus() {
        return this.wfStatus;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="billDate")
    public void setBillDate(Long billDate) {
        this.billDate = billDate;
    }

    @JsonProperty(value="dueDate")
    public void setDueDate(Long dueDate) {
        this.dueDate = dueDate;
    }

    @JsonProperty(value="totalAmount")
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @JsonProperty(value="totalPaidAmount")
    public void setTotalPaidAmount(BigDecimal totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="fromPeriod")
    public void setFromPeriod(Long fromPeriod) {
        this.fromPeriod = fromPeriod;
    }

    @JsonProperty(value="toPeriod")
    public void setToPeriod(Long toPeriod) {
        this.toPeriod = toPeriod;
    }

    @JsonProperty(value="paymentStatus")
    public void setPaymentStatus(PaymentStatus paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="billNumber")
    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    @JsonProperty(value="payer")
    public void setPayer(Party payer) {
        this.payer = payer;
    }

    @JsonProperty(value="billDetails")
    public void setBillDetails(List<BillDetail> billDetails) {
        this.billDetails = billDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="wfStatus")
    public void setWfStatus(String wfStatus) {
        this.wfStatus = wfStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bill)) {
            return false;
        }
        Bill other = (Bill)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$billDate = this.getBillDate();
        Long other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !((Object)this$billDate).equals(other$billDate)) {
            return false;
        }
        Long this$dueDate = this.getDueDate();
        Long other$dueDate = other.getDueDate();
        if (this$dueDate == null ? other$dueDate != null : !((Object)this$dueDate).equals(other$dueDate)) {
            return false;
        }
        Long this$fromPeriod = this.getFromPeriod();
        Long other$fromPeriod = other.getFromPeriod();
        if (this$fromPeriod == null ? other$fromPeriod != null : !((Object)this$fromPeriod).equals(other$fromPeriod)) {
            return false;
        }
        Long this$toPeriod = this.getToPeriod();
        Long other$toPeriod = other.getToPeriod();
        if (this$toPeriod == null ? other$toPeriod != null : !((Object)this$toPeriod).equals(other$toPeriod)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        BigDecimal this$totalAmount = this.getTotalAmount();
        BigDecimal other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !((Object)this$totalAmount).equals(other$totalAmount)) {
            return false;
        }
        BigDecimal this$totalPaidAmount = this.getTotalPaidAmount();
        BigDecimal other$totalPaidAmount = other.getTotalPaidAmount();
        if (this$totalPaidAmount == null ? other$totalPaidAmount != null : !((Object)this$totalPaidAmount).equals(other$totalPaidAmount)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        if (this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        PaymentStatus this$paymentStatus = this.getPaymentStatus();
        PaymentStatus other$paymentStatus = other.getPaymentStatus();
        if (this$paymentStatus == null ? other$paymentStatus != null : !((Object)((Object)this$paymentStatus)).equals((Object)other$paymentStatus)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$billNumber = this.getBillNumber();
        String other$billNumber = other.getBillNumber();
        if (this$billNumber == null ? other$billNumber != null : !this$billNumber.equals(other$billNumber)) {
            return false;
        }
        Party this$payer = this.getPayer();
        Party other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
            return false;
        }
        List<BillDetail> this$billDetails = this.getBillDetails();
        List<BillDetail> other$billDetails = other.getBillDetails();
        if (this$billDetails == null ? other$billDetails != null : !((Object)this$billDetails).equals(other$billDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        String this$wfStatus = this.getWfStatus();
        String other$wfStatus = other.getWfStatus();
        return !(this$wfStatus == null ? other$wfStatus != null : !this$wfStatus.equals(other$wfStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bill;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : ((Object)$billDate).hashCode());
        Long $dueDate = this.getDueDate();
        result = result * 59 + ($dueDate == null ? 43 : ((Object)$dueDate).hashCode());
        Long $fromPeriod = this.getFromPeriod();
        result = result * 59 + ($fromPeriod == null ? 43 : ((Object)$fromPeriod).hashCode());
        Long $toPeriod = this.getToPeriod();
        result = result * 59 + ($toPeriod == null ? 43 : ((Object)$toPeriod).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        BigDecimal $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : ((Object)$totalAmount).hashCode());
        BigDecimal $totalPaidAmount = this.getTotalPaidAmount();
        result = result * 59 + ($totalPaidAmount == null ? 43 : ((Object)$totalPaidAmount).hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        PaymentStatus $paymentStatus = this.getPaymentStatus();
        result = result * 59 + ($paymentStatus == null ? 43 : ((Object)((Object)$paymentStatus)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $billNumber = this.getBillNumber();
        result = result * 59 + ($billNumber == null ? 43 : $billNumber.hashCode());
        Party $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        List<BillDetail> $billDetails = this.getBillDetails();
        result = result * 59 + ($billDetails == null ? 43 : ((Object)$billDetails).hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        String $wfStatus = this.getWfStatus();
        result = result * 59 + ($wfStatus == null ? 43 : $wfStatus.hashCode());
        return result;
    }

    public String toString() {
        return "Bill(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", billDate=" + this.getBillDate() + ", dueDate=" + this.getDueDate() + ", totalAmount=" + this.getTotalAmount() + ", totalPaidAmount=" + this.getTotalPaidAmount() + ", businessService=" + this.getBusinessService() + ", referenceId=" + this.getReferenceId() + ", fromPeriod=" + this.getFromPeriod() + ", toPeriod=" + this.getToPeriod() + ", paymentStatus=" + this.getPaymentStatus() + ", status=" + this.getStatus() + ", billNumber=" + this.getBillNumber() + ", payer=" + this.getPayer() + ", billDetails=" + this.getBillDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ", auditDetails=" + this.getAuditDetails() + ", wfStatus=" + this.getWfStatus() + ")";
    }

    public Bill(String id, String tenantId, Long billDate, Long dueDate, BigDecimal totalAmount, BigDecimal totalPaidAmount, String businessService, String referenceId, Long fromPeriod, Long toPeriod, PaymentStatus paymentStatus, Status status, String billNumber, Party payer, List<BillDetail> billDetails, Object additionalDetails, AuditDetails auditDetails, String wfStatus) {
        this.id = id;
        this.tenantId = tenantId;
        this.billDate = billDate;
        this.dueDate = dueDate;
        this.totalAmount = totalAmount;
        this.totalPaidAmount = totalPaidAmount;
        this.businessService = businessService;
        this.referenceId = referenceId;
        this.fromPeriod = fromPeriod;
        this.toPeriod = toPeriod;
        this.paymentStatus = paymentStatus;
        this.status = status;
        this.billNumber = billNumber;
        this.payer = payer;
        this.billDetails = billDetails;
        this.additionalDetails = additionalDetails;
        this.auditDetails = auditDetails;
        this.wfStatus = wfStatus;
    }

    public Bill() {
        this.totalAmount = Bill.$default$totalAmount();
        this.totalPaidAmount = Bill.$default$totalPaidAmount();
    }

    public static class BillBuilder {
        private String id;
        private String tenantId;
        private Long billDate;
        private Long dueDate;
        private boolean totalAmount$set;
        private BigDecimal totalAmount$value;
        private boolean totalPaidAmount$set;
        private BigDecimal totalPaidAmount$value;
        private String businessService;
        private String referenceId;
        private Long fromPeriod;
        private Long toPeriod;
        private PaymentStatus paymentStatus;
        private Status status;
        private String billNumber;
        private Party payer;
        private List<BillDetail> billDetails;
        private Object additionalDetails;
        private AuditDetails auditDetails;
        private String wfStatus;

        BillBuilder() {
        }

        @JsonProperty(value="id")
        public BillBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public BillBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="billDate")
        public BillBuilder billDate(Long billDate) {
            this.billDate = billDate;
            return this;
        }

        @JsonProperty(value="dueDate")
        public BillBuilder dueDate(Long dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        @JsonProperty(value="totalAmount")
        public BillBuilder totalAmount(BigDecimal totalAmount) {
            this.totalAmount$value = totalAmount;
            this.totalAmount$set = true;
            return this;
        }

        @JsonProperty(value="totalPaidAmount")
        public BillBuilder totalPaidAmount(BigDecimal totalPaidAmount) {
            this.totalPaidAmount$value = totalPaidAmount;
            this.totalPaidAmount$set = true;
            return this;
        }

        @JsonProperty(value="businessService")
        public BillBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="referenceId")
        public BillBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="fromPeriod")
        public BillBuilder fromPeriod(Long fromPeriod) {
            this.fromPeriod = fromPeriod;
            return this;
        }

        @JsonProperty(value="toPeriod")
        public BillBuilder toPeriod(Long toPeriod) {
            this.toPeriod = toPeriod;
            return this;
        }

        @JsonProperty(value="paymentStatus")
        public BillBuilder paymentStatus(PaymentStatus paymentStatus) {
            this.paymentStatus = paymentStatus;
            return this;
        }

        @JsonProperty(value="status")
        public BillBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="billNumber")
        public BillBuilder billNumber(String billNumber) {
            this.billNumber = billNumber;
            return this;
        }

        @JsonProperty(value="payer")
        public BillBuilder payer(Party payer) {
            this.payer = payer;
            return this;
        }

        @JsonProperty(value="billDetails")
        public BillBuilder billDetails(List<BillDetail> billDetails) {
            this.billDetails = billDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public BillBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BillBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="wfStatus")
        public BillBuilder wfStatus(String wfStatus) {
            this.wfStatus = wfStatus;
            return this;
        }

        public Bill build() {
            BigDecimal totalAmount$value = this.totalAmount$value;
            if (!this.totalAmount$set) {
                totalAmount$value = Bill.$default$totalAmount();
            }
            BigDecimal totalPaidAmount$value = this.totalPaidAmount$value;
            if (!this.totalPaidAmount$set) {
                totalPaidAmount$value = Bill.$default$totalPaidAmount();
            }
            return new Bill(this.id, this.tenantId, this.billDate, this.dueDate, totalAmount$value, totalPaidAmount$value, this.businessService, this.referenceId, this.fromPeriod, this.toPeriod, this.paymentStatus, this.status, this.billNumber, this.payer, this.billDetails, this.additionalDetails, this.auditDetails, this.wfStatus);
        }

        public String toString() {
            return "Bill.BillBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", billDate=" + this.billDate + ", dueDate=" + this.dueDate + ", totalAmount$value=" + this.totalAmount$value + ", totalPaidAmount$value=" + this.totalPaidAmount$value + ", businessService=" + this.businessService + ", referenceId=" + this.referenceId + ", fromPeriod=" + this.fromPeriod + ", toPeriod=" + this.toPeriod + ", paymentStatus=" + this.paymentStatus + ", status=" + this.status + ", billNumber=" + this.billNumber + ", payer=" + this.payer + ", billDetails=" + this.billDetails + ", additionalDetails=" + this.additionalDetails + ", auditDetails=" + this.auditDetails + ", wfStatus=" + this.wfStatus + ")";
        }
    }
}

