/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.estimate;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.estimate.Estimate;

public class EstimateResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="estimates")
    @Valid
    private List<Estimate> estimates = new ArrayList<Estimate>();
    @JsonProperty(value="TotalCount")
    private Integer totalCount = 0;

    public EstimateResponse addEstimatesItem(Estimate estimatesItem) {
        this.estimates.add(estimatesItem);
        return this;
    }

    public static EstimateResponseBuilder builder() {
        return new EstimateResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Estimate> getEstimates() {
        return this.estimates;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="estimates")
    public void setEstimates(List<Estimate> estimates) {
        this.estimates = estimates;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public EstimateResponse(ResponseInfo responseInfo, List<Estimate> estimates, Integer totalCount) {
        this.responseInfo = responseInfo;
        this.estimates = estimates;
        this.totalCount = totalCount;
    }

    public EstimateResponse() {
    }

    public static class EstimateResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Estimate> estimates;
        private Integer totalCount;

        EstimateResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public EstimateResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="estimates")
        public EstimateResponseBuilder estimates(List<Estimate> estimates) {
            this.estimates = estimates;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public EstimateResponseBuilder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public EstimateResponse build() {
            return new EstimateResponse(this.responseInfo, this.estimates, this.totalCount);
        }

        public String toString() {
            return "EstimateResponse.EstimateResponseBuilder(responseInfo=" + this.responseInfo + ", estimates=" + this.estimates + ", totalCount=" + this.totalCount + ")";
        }
    }
}

