/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.estimate;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import org.egov.common.contract.models.Workflow;
import org.egov.common.contract.request.RequestInfo;
import org.egov.works.services.common.models.estimate.Estimate;

public class EstimateRequest {
    @JsonProperty(value="RequestInfo")
    private RequestInfo requestInfo = null;
    @JsonProperty(value="estimate")
    @Valid
    private Estimate estimate = null;
    @JsonProperty(value="workflow")
    private Workflow workflow = null;

    public static EstimateRequestBuilder builder() {
        return new EstimateRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public Estimate getEstimate() {
        return this.estimate;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="estimate")
    public void setEstimate(Estimate estimate) {
        this.estimate = estimate;
    }

    @JsonProperty(value="workflow")
    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public EstimateRequest(RequestInfo requestInfo, Estimate estimate, Workflow workflow) {
        this.requestInfo = requestInfo;
        this.estimate = estimate;
        this.workflow = workflow;
    }

    public EstimateRequest() {
    }

    public static class EstimateRequestBuilder {
        private RequestInfo requestInfo;
        private Estimate estimate;
        private Workflow workflow;

        EstimateRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public EstimateRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="estimate")
        public EstimateRequestBuilder estimate(Estimate estimate) {
            this.estimate = estimate;
            return this;
        }

        @JsonProperty(value="workflow")
        public EstimateRequestBuilder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public EstimateRequest build() {
            return new EstimateRequest(this.requestInfo, this.estimate, this.workflow);
        }

        public String toString() {
            return "EstimateRequest.EstimateRequestBuilder(requestInfo=" + this.requestInfo + ", estimate=" + this.estimate + ", workflow=" + this.workflow + ")";
        }
    }
}

