/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.estimate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.Address;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.workflow.ProcessInstance;
import org.egov.works.services.common.models.estimate.EstimateDetail;

public class Estimate {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="tenantId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="estimateNumber")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String estimateNumber = null;
    @JsonProperty(value="revisionNumber")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String revisionNumber = null;
    @JsonProperty(value="businessService")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String businessService = null;
    @JsonProperty(value="versionNumber")
    private BigDecimal versionNumber = null;
    @JsonProperty(value="oldUuid")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String oldUuid = null;
    @JsonProperty(value="projectId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="proposalDate")
    private BigDecimal proposalDate = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="wfStatus")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String wfStatus = null;
    @JsonProperty(value="name")
    @Size(min=2, max=140)
    private @Size(min=2, max=140) String name = null;
    @JsonProperty(value="referenceNumber")
    @Size(min=2, max=140)
    private @Size(min=2, max=140) String referenceNumber = null;
    @JsonProperty(value="description")
    @Size(min=2, max=240)
    private @Size(min=2, max=240) String description = null;
    @JsonProperty(value="executingDepartment")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String executingDepartment = null;
    @JsonProperty(value="address")
    private Address address = null;
    @JsonProperty(value="estimateDetails")
    @Valid
    private List<EstimateDetail> estimateDetails = new ArrayList<EstimateDetail>();
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="ProcessInstances")
    @Valid
    private ProcessInstance processInstances = null;

    public Estimate addEstimateDetailsItem(EstimateDetail estimateDetailsItem) {
        this.estimateDetails.add(estimateDetailsItem);
        return this;
    }

    public static EstimateBuilder builder() {
        return new EstimateBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public BigDecimal getVersionNumber() {
        return this.versionNumber;
    }

    public String getOldUuid() {
        return this.oldUuid;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public BigDecimal getProposalDate() {
        return this.proposalDate;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public String getWfStatus() {
        return this.wfStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutingDepartment() {
        return this.executingDepartment;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<EstimateDetail> getEstimateDetails() {
        return this.estimateDetails;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public ProcessInstance getProcessInstances() {
        return this.processInstances;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="estimateNumber")
    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    @JsonProperty(value="revisionNumber")
    public void setRevisionNumber(String revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="versionNumber")
    public void setVersionNumber(BigDecimal versionNumber) {
        this.versionNumber = versionNumber;
    }

    @JsonProperty(value="oldUuid")
    public void setOldUuid(String oldUuid) {
        this.oldUuid = oldUuid;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="proposalDate")
    public void setProposalDate(BigDecimal proposalDate) {
        this.proposalDate = proposalDate;
    }

    @JsonProperty(value="status")
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @JsonProperty(value="wfStatus")
    public void setWfStatus(String wfStatus) {
        this.wfStatus = wfStatus;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="referenceNumber")
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="executingDepartment")
    public void setExecutingDepartment(String executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="estimateDetails")
    public void setEstimateDetails(List<EstimateDetail> estimateDetails) {
        this.estimateDetails = estimateDetails;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="ProcessInstances")
    public void setProcessInstances(ProcessInstance processInstances) {
        this.processInstances = processInstances;
    }

    public Estimate(String id, String tenantId, String estimateNumber, String revisionNumber, String businessService, BigDecimal versionNumber, String oldUuid, String projectId, BigDecimal proposalDate, StatusEnum status, String wfStatus, String name, String referenceNumber, String description, String executingDepartment, Address address, List<EstimateDetail> estimateDetails, AuditDetails auditDetails, Object additionalDetails, ProcessInstance processInstances) {
        this.id = id;
        this.tenantId = tenantId;
        this.estimateNumber = estimateNumber;
        this.revisionNumber = revisionNumber;
        this.businessService = businessService;
        this.versionNumber = versionNumber;
        this.oldUuid = oldUuid;
        this.projectId = projectId;
        this.proposalDate = proposalDate;
        this.status = status;
        this.wfStatus = wfStatus;
        this.name = name;
        this.referenceNumber = referenceNumber;
        this.description = description;
        this.executingDepartment = executingDepartment;
        this.address = address;
        this.estimateDetails = estimateDetails;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
        this.processInstances = processInstances;
    }

    public Estimate() {
    }

    public static class EstimateBuilder {
        private String id;
        private String tenantId;
        private String estimateNumber;
        private String revisionNumber;
        private String businessService;
        private BigDecimal versionNumber;
        private String oldUuid;
        private String projectId;
        private BigDecimal proposalDate;
        private StatusEnum status;
        private String wfStatus;
        private String name;
        private String referenceNumber;
        private String description;
        private String executingDepartment;
        private Address address;
        private List<EstimateDetail> estimateDetails;
        private AuditDetails auditDetails;
        private Object additionalDetails;
        private ProcessInstance processInstances;

        EstimateBuilder() {
        }

        @JsonProperty(value="id")
        public EstimateBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public EstimateBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="estimateNumber")
        public EstimateBuilder estimateNumber(String estimateNumber) {
            this.estimateNumber = estimateNumber;
            return this;
        }

        @JsonProperty(value="revisionNumber")
        public EstimateBuilder revisionNumber(String revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        @JsonProperty(value="businessService")
        public EstimateBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="versionNumber")
        public EstimateBuilder versionNumber(BigDecimal versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @JsonProperty(value="oldUuid")
        public EstimateBuilder oldUuid(String oldUuid) {
            this.oldUuid = oldUuid;
            return this;
        }

        @JsonProperty(value="projectId")
        public EstimateBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="proposalDate")
        public EstimateBuilder proposalDate(BigDecimal proposalDate) {
            this.proposalDate = proposalDate;
            return this;
        }

        @JsonProperty(value="status")
        public EstimateBuilder status(StatusEnum status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="wfStatus")
        public EstimateBuilder wfStatus(String wfStatus) {
            this.wfStatus = wfStatus;
            return this;
        }

        @JsonProperty(value="name")
        public EstimateBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="referenceNumber")
        public EstimateBuilder referenceNumber(String referenceNumber) {
            this.referenceNumber = referenceNumber;
            return this;
        }

        @JsonProperty(value="description")
        public EstimateBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="executingDepartment")
        public EstimateBuilder executingDepartment(String executingDepartment) {
            this.executingDepartment = executingDepartment;
            return this;
        }

        @JsonProperty(value="address")
        public EstimateBuilder address(Address address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="estimateDetails")
        public EstimateBuilder estimateDetails(List<EstimateDetail> estimateDetails) {
            this.estimateDetails = estimateDetails;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public EstimateBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public EstimateBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="ProcessInstances")
        public EstimateBuilder processInstances(ProcessInstance processInstances) {
            this.processInstances = processInstances;
            return this;
        }

        public Estimate build() {
            return new Estimate(this.id, this.tenantId, this.estimateNumber, this.revisionNumber, this.businessService, this.versionNumber, this.oldUuid, this.projectId, this.proposalDate, this.status, this.wfStatus, this.name, this.referenceNumber, this.description, this.executingDepartment, this.address, this.estimateDetails, this.auditDetails, this.additionalDetails, this.processInstances);
        }

        public String toString() {
            return "Estimate.EstimateBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", estimateNumber=" + this.estimateNumber + ", revisionNumber=" + this.revisionNumber + ", businessService=" + this.businessService + ", versionNumber=" + this.versionNumber + ", oldUuid=" + this.oldUuid + ", projectId=" + this.projectId + ", proposalDate=" + this.proposalDate + ", status=" + this.status + ", wfStatus=" + this.wfStatus + ", name=" + this.name + ", referenceNumber=" + this.referenceNumber + ", description=" + this.description + ", executingDepartment=" + this.executingDepartment + ", address=" + this.address + ", estimateDetails=" + this.estimateDetails + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ", processInstances=" + this.processInstances + ")";
        }
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        INWORKFLOW("INWORKFLOW"),
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

