/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.contract;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.contract.Contract;
import org.egov.works.services.common.models.contract.Pagination;

public class ContractResponse {
    @JsonProperty(value="ResponseInfo")
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="contracts")
    @Valid
    private List<Contract> contracts = null;
    @JsonProperty(value="pagination")
    @Valid
    private Pagination pagination = null;

    public ContractResponse addContractsItem(Contract contractsItem) {
        if (this.contracts == null) {
            this.contracts = new ArrayList<Contract>();
        }
        this.contracts.add(contractsItem);
        return this;
    }

    public static ContractResponseBuilder builder() {
        return new ContractResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Contract> getContracts() {
        return this.contracts;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="contracts")
    public void setContracts(List<Contract> contracts) {
        this.contracts = contracts;
    }

    @JsonProperty(value="pagination")
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractResponse)) {
            return false;
        }
        ContractResponse other = (ContractResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Contract> this$contracts = this.getContracts();
        List<Contract> other$contracts = other.getContracts();
        if (this$contracts == null ? other$contracts != null : !((Object)this$contracts).equals(other$contracts)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Contract> $contracts = this.getContracts();
        result = result * 59 + ($contracts == null ? 43 : ((Object)$contracts).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public String toString() {
        return "ContractResponse(responseInfo=" + this.getResponseInfo() + ", contracts=" + this.getContracts() + ", pagination=" + this.getPagination() + ")";
    }

    public ContractResponse(ResponseInfo responseInfo, List<Contract> contracts, Pagination pagination) {
        this.responseInfo = responseInfo;
        this.contracts = contracts;
        this.pagination = pagination;
    }

    public ContractResponse() {
    }

    public static class ContractResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Contract> contracts;
        private Pagination pagination;

        ContractResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ContractResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="contracts")
        public ContractResponseBuilder contracts(List<Contract> contracts) {
            this.contracts = contracts;
            return this;
        }

        @JsonProperty(value="pagination")
        public ContractResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public ContractResponse build() {
            return new ContractResponse(this.responseInfo, this.contracts, this.pagination);
        }

        public String toString() {
            return "ContractResponse.ContractResponseBuilder(responseInfo=" + this.responseInfo + ", contracts=" + this.contracts + ", pagination=" + this.pagination + ")";
        }
    }
}

