/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.contract;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.workflow.ProcessInstance;
import org.egov.works.services.common.models.contract.Document;
import org.egov.works.services.common.models.contract.LineItems;
import org.egov.works.services.common.models.contract.Status;

public class Contract {
    @JsonProperty(value="id")
    @Valid
    private String id = null;
    @JsonProperty(value="contractNumber")
    @Size(min=1, max=64)
    private @Size(min=1, max=64) String contractNumber = null;
    @JsonProperty(value="supplementNumber")
    private String supplementNumber = null;
    @JsonProperty(value="versionNumber")
    private Long versionNumber = null;
    @JsonProperty(value="oldUuid")
    private String oldUuid = null;
    @JsonProperty(value="businessService")
    private String businessService = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="wfStatus")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String wfStatus = null;
    @JsonProperty(value="executingAuthority")
    @NotNull
    private String executingAuthority = null;
    @JsonProperty(value="contractType")
    private String contractType = null;
    @JsonProperty(value="totalContractedAmount")
    @Valid
    private BigDecimal totalContractedAmount = null;
    @JsonProperty(value="securityDeposit")
    @Valid
    private BigDecimal securityDeposit = null;
    @JsonProperty(value="agreementDate")
    @Valid
    private BigDecimal agreementDate = null;
    @JsonProperty(value="issueDate")
    @Valid
    private BigDecimal issueDate = null;
    @JsonProperty(value="defectLiabilityPeriod")
    @Valid
    private BigDecimal defectLiabilityPeriod = null;
    @JsonProperty(value="orgId")
    private String orgId = null;
    @JsonProperty(value="startDate")
    @Valid
    private BigDecimal startDate = null;
    @JsonProperty(value="endDate")
    @Valid
    private BigDecimal endDate = null;
    @JsonProperty(value="completionPeriod")
    @Valid
    private Integer completionPeriod = null;
    @JsonProperty(value="status")
    @Valid
    private Status status = null;
    @JsonProperty(value="lineItems")
    @Valid
    private List<LineItems> lineItems = null;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="processInstance")
    private ProcessInstance processInstance = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;

    public Contract addLineItemsItem(LineItems lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItems>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    public Contract addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public static ContractBuilder builder() {
        return new ContractBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public String getSupplementNumber() {
        return this.supplementNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getOldUuid() {
        return this.oldUuid;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getWfStatus() {
        return this.wfStatus;
    }

    public String getExecutingAuthority() {
        return this.executingAuthority;
    }

    public String getContractType() {
        return this.contractType;
    }

    public BigDecimal getTotalContractedAmount() {
        return this.totalContractedAmount;
    }

    public BigDecimal getSecurityDeposit() {
        return this.securityDeposit;
    }

    public BigDecimal getAgreementDate() {
        return this.agreementDate;
    }

    public BigDecimal getIssueDate() {
        return this.issueDate;
    }

    public BigDecimal getDefectLiabilityPeriod() {
        return this.defectLiabilityPeriod;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public BigDecimal getStartDate() {
        return this.startDate;
    }

    public BigDecimal getEndDate() {
        return this.endDate;
    }

    public Integer getCompletionPeriod() {
        return this.completionPeriod;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<LineItems> getLineItems() {
        return this.lineItems;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="contractNumber")
    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    @JsonProperty(value="supplementNumber")
    public void setSupplementNumber(String supplementNumber) {
        this.supplementNumber = supplementNumber;
    }

    @JsonProperty(value="versionNumber")
    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    @JsonProperty(value="oldUuid")
    public void setOldUuid(String oldUuid) {
        this.oldUuid = oldUuid;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="wfStatus")
    public void setWfStatus(String wfStatus) {
        this.wfStatus = wfStatus;
    }

    @JsonProperty(value="executingAuthority")
    public void setExecutingAuthority(String executingAuthority) {
        this.executingAuthority = executingAuthority;
    }

    @JsonProperty(value="contractType")
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    @JsonProperty(value="totalContractedAmount")
    public void setTotalContractedAmount(BigDecimal totalContractedAmount) {
        this.totalContractedAmount = totalContractedAmount;
    }

    @JsonProperty(value="securityDeposit")
    public void setSecurityDeposit(BigDecimal securityDeposit) {
        this.securityDeposit = securityDeposit;
    }

    @JsonProperty(value="agreementDate")
    public void setAgreementDate(BigDecimal agreementDate) {
        this.agreementDate = agreementDate;
    }

    @JsonProperty(value="issueDate")
    public void setIssueDate(BigDecimal issueDate) {
        this.issueDate = issueDate;
    }

    @JsonProperty(value="defectLiabilityPeriod")
    public void setDefectLiabilityPeriod(BigDecimal defectLiabilityPeriod) {
        this.defectLiabilityPeriod = defectLiabilityPeriod;
    }

    @JsonProperty(value="orgId")
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(BigDecimal startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(BigDecimal endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="completionPeriod")
    public void setCompletionPeriod(Integer completionPeriod) {
        this.completionPeriod = completionPeriod;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="lineItems")
    public void setLineItems(List<LineItems> lineItems) {
        this.lineItems = lineItems;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="processInstance")
    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract other = (Contract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$versionNumber = this.getVersionNumber();
        Long other$versionNumber = other.getVersionNumber();
        if (this$versionNumber == null ? other$versionNumber != null : !((Object)this$versionNumber).equals(other$versionNumber)) {
            return false;
        }
        Integer this$completionPeriod = this.getCompletionPeriod();
        Integer other$completionPeriod = other.getCompletionPeriod();
        if (this$completionPeriod == null ? other$completionPeriod != null : !((Object)this$completionPeriod).equals(other$completionPeriod)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$contractNumber = this.getContractNumber();
        String other$contractNumber = other.getContractNumber();
        if (this$contractNumber == null ? other$contractNumber != null : !this$contractNumber.equals(other$contractNumber)) {
            return false;
        }
        String this$supplementNumber = this.getSupplementNumber();
        String other$supplementNumber = other.getSupplementNumber();
        if (this$supplementNumber == null ? other$supplementNumber != null : !this$supplementNumber.equals(other$supplementNumber)) {
            return false;
        }
        String this$oldUuid = this.getOldUuid();
        String other$oldUuid = other.getOldUuid();
        if (this$oldUuid == null ? other$oldUuid != null : !this$oldUuid.equals(other$oldUuid)) {
            return false;
        }
        String this$businessService = this.getBusinessService();
        String other$businessService = other.getBusinessService();
        if (this$businessService == null ? other$businessService != null : !this$businessService.equals(other$businessService)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$wfStatus = this.getWfStatus();
        String other$wfStatus = other.getWfStatus();
        if (this$wfStatus == null ? other$wfStatus != null : !this$wfStatus.equals(other$wfStatus)) {
            return false;
        }
        String this$executingAuthority = this.getExecutingAuthority();
        String other$executingAuthority = other.getExecutingAuthority();
        if (this$executingAuthority == null ? other$executingAuthority != null : !this$executingAuthority.equals(other$executingAuthority)) {
            return false;
        }
        String this$contractType = this.getContractType();
        String other$contractType = other.getContractType();
        if (this$contractType == null ? other$contractType != null : !this$contractType.equals(other$contractType)) {
            return false;
        }
        BigDecimal this$totalContractedAmount = this.getTotalContractedAmount();
        BigDecimal other$totalContractedAmount = other.getTotalContractedAmount();
        if (this$totalContractedAmount == null ? other$totalContractedAmount != null : !((Object)this$totalContractedAmount).equals(other$totalContractedAmount)) {
            return false;
        }
        BigDecimal this$securityDeposit = this.getSecurityDeposit();
        BigDecimal other$securityDeposit = other.getSecurityDeposit();
        if (this$securityDeposit == null ? other$securityDeposit != null : !((Object)this$securityDeposit).equals(other$securityDeposit)) {
            return false;
        }
        BigDecimal this$agreementDate = this.getAgreementDate();
        BigDecimal other$agreementDate = other.getAgreementDate();
        if (this$agreementDate == null ? other$agreementDate != null : !((Object)this$agreementDate).equals(other$agreementDate)) {
            return false;
        }
        BigDecimal this$issueDate = this.getIssueDate();
        BigDecimal other$issueDate = other.getIssueDate();
        if (this$issueDate == null ? other$issueDate != null : !((Object)this$issueDate).equals(other$issueDate)) {
            return false;
        }
        BigDecimal this$defectLiabilityPeriod = this.getDefectLiabilityPeriod();
        BigDecimal other$defectLiabilityPeriod = other.getDefectLiabilityPeriod();
        if (this$defectLiabilityPeriod == null ? other$defectLiabilityPeriod != null : !((Object)this$defectLiabilityPeriod).equals(other$defectLiabilityPeriod)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        BigDecimal this$startDate = this.getStartDate();
        BigDecimal other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        BigDecimal this$endDate = this.getEndDate();
        BigDecimal other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        List<LineItems> this$lineItems = this.getLineItems();
        List<LineItems> other$lineItems = other.getLineItems();
        if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        ProcessInstance this$processInstance = this.getProcessInstance();
        ProcessInstance other$processInstance = other.getProcessInstance();
        if (this$processInstance == null ? other$processInstance != null : !this$processInstance.equals(other$processInstance)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Contract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $versionNumber = this.getVersionNumber();
        result = result * 59 + ($versionNumber == null ? 43 : ((Object)$versionNumber).hashCode());
        Integer $completionPeriod = this.getCompletionPeriod();
        result = result * 59 + ($completionPeriod == null ? 43 : ((Object)$completionPeriod).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $contractNumber = this.getContractNumber();
        result = result * 59 + ($contractNumber == null ? 43 : $contractNumber.hashCode());
        String $supplementNumber = this.getSupplementNumber();
        result = result * 59 + ($supplementNumber == null ? 43 : $supplementNumber.hashCode());
        String $oldUuid = this.getOldUuid();
        result = result * 59 + ($oldUuid == null ? 43 : $oldUuid.hashCode());
        String $businessService = this.getBusinessService();
        result = result * 59 + ($businessService == null ? 43 : $businessService.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $wfStatus = this.getWfStatus();
        result = result * 59 + ($wfStatus == null ? 43 : $wfStatus.hashCode());
        String $executingAuthority = this.getExecutingAuthority();
        result = result * 59 + ($executingAuthority == null ? 43 : $executingAuthority.hashCode());
        String $contractType = this.getContractType();
        result = result * 59 + ($contractType == null ? 43 : $contractType.hashCode());
        BigDecimal $totalContractedAmount = this.getTotalContractedAmount();
        result = result * 59 + ($totalContractedAmount == null ? 43 : ((Object)$totalContractedAmount).hashCode());
        BigDecimal $securityDeposit = this.getSecurityDeposit();
        result = result * 59 + ($securityDeposit == null ? 43 : ((Object)$securityDeposit).hashCode());
        BigDecimal $agreementDate = this.getAgreementDate();
        result = result * 59 + ($agreementDate == null ? 43 : ((Object)$agreementDate).hashCode());
        BigDecimal $issueDate = this.getIssueDate();
        result = result * 59 + ($issueDate == null ? 43 : ((Object)$issueDate).hashCode());
        BigDecimal $defectLiabilityPeriod = this.getDefectLiabilityPeriod();
        result = result * 59 + ($defectLiabilityPeriod == null ? 43 : ((Object)$defectLiabilityPeriod).hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        BigDecimal $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        BigDecimal $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        List<LineItems> $lineItems = this.getLineItems();
        result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        ProcessInstance $processInstance = this.getProcessInstance();
        result = result * 59 + ($processInstance == null ? 43 : $processInstance.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Contract(id=" + this.getId() + ", contractNumber=" + this.getContractNumber() + ", supplementNumber=" + this.getSupplementNumber() + ", versionNumber=" + this.getVersionNumber() + ", oldUuid=" + this.getOldUuid() + ", businessService=" + this.getBusinessService() + ", tenantId=" + this.getTenantId() + ", wfStatus=" + this.getWfStatus() + ", executingAuthority=" + this.getExecutingAuthority() + ", contractType=" + this.getContractType() + ", totalContractedAmount=" + this.getTotalContractedAmount() + ", securityDeposit=" + this.getSecurityDeposit() + ", agreementDate=" + this.getAgreementDate() + ", issueDate=" + this.getIssueDate() + ", defectLiabilityPeriod=" + this.getDefectLiabilityPeriod() + ", orgId=" + this.getOrgId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", completionPeriod=" + this.getCompletionPeriod() + ", status=" + this.getStatus() + ", lineItems=" + this.getLineItems() + ", documents=" + this.getDocuments() + ", processInstance=" + this.getProcessInstance() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ")";
    }

    public Contract(String id, String contractNumber, String supplementNumber, Long versionNumber, String oldUuid, String businessService, String tenantId, String wfStatus, String executingAuthority, String contractType, BigDecimal totalContractedAmount, BigDecimal securityDeposit, BigDecimal agreementDate, BigDecimal issueDate, BigDecimal defectLiabilityPeriod, String orgId, BigDecimal startDate, BigDecimal endDate, Integer completionPeriod, Status status, List<LineItems> lineItems, List<Document> documents, ProcessInstance processInstance, AuditDetails auditDetails, Object additionalDetails) {
        this.id = id;
        this.contractNumber = contractNumber;
        this.supplementNumber = supplementNumber;
        this.versionNumber = versionNumber;
        this.oldUuid = oldUuid;
        this.businessService = businessService;
        this.tenantId = tenantId;
        this.wfStatus = wfStatus;
        this.executingAuthority = executingAuthority;
        this.contractType = contractType;
        this.totalContractedAmount = totalContractedAmount;
        this.securityDeposit = securityDeposit;
        this.agreementDate = agreementDate;
        this.issueDate = issueDate;
        this.defectLiabilityPeriod = defectLiabilityPeriod;
        this.orgId = orgId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.completionPeriod = completionPeriod;
        this.status = status;
        this.lineItems = lineItems;
        this.documents = documents;
        this.processInstance = processInstance;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public Contract() {
    }

    public static class ContractBuilder {
        private String id;
        private String contractNumber;
        private String supplementNumber;
        private Long versionNumber;
        private String oldUuid;
        private String businessService;
        private String tenantId;
        private String wfStatus;
        private String executingAuthority;
        private String contractType;
        private BigDecimal totalContractedAmount;
        private BigDecimal securityDeposit;
        private BigDecimal agreementDate;
        private BigDecimal issueDate;
        private BigDecimal defectLiabilityPeriod;
        private String orgId;
        private BigDecimal startDate;
        private BigDecimal endDate;
        private Integer completionPeriod;
        private Status status;
        private List<LineItems> lineItems;
        private List<Document> documents;
        private ProcessInstance processInstance;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        ContractBuilder() {
        }

        @JsonProperty(value="id")
        public ContractBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="contractNumber")
        public ContractBuilder contractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
            return this;
        }

        @JsonProperty(value="supplementNumber")
        public ContractBuilder supplementNumber(String supplementNumber) {
            this.supplementNumber = supplementNumber;
            return this;
        }

        @JsonProperty(value="versionNumber")
        public ContractBuilder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @JsonProperty(value="oldUuid")
        public ContractBuilder oldUuid(String oldUuid) {
            this.oldUuid = oldUuid;
            return this;
        }

        @JsonProperty(value="businessService")
        public ContractBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ContractBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="wfStatus")
        public ContractBuilder wfStatus(String wfStatus) {
            this.wfStatus = wfStatus;
            return this;
        }

        @JsonProperty(value="executingAuthority")
        public ContractBuilder executingAuthority(String executingAuthority) {
            this.executingAuthority = executingAuthority;
            return this;
        }

        @JsonProperty(value="contractType")
        public ContractBuilder contractType(String contractType) {
            this.contractType = contractType;
            return this;
        }

        @JsonProperty(value="totalContractedAmount")
        public ContractBuilder totalContractedAmount(BigDecimal totalContractedAmount) {
            this.totalContractedAmount = totalContractedAmount;
            return this;
        }

        @JsonProperty(value="securityDeposit")
        public ContractBuilder securityDeposit(BigDecimal securityDeposit) {
            this.securityDeposit = securityDeposit;
            return this;
        }

        @JsonProperty(value="agreementDate")
        public ContractBuilder agreementDate(BigDecimal agreementDate) {
            this.agreementDate = agreementDate;
            return this;
        }

        @JsonProperty(value="issueDate")
        public ContractBuilder issueDate(BigDecimal issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        @JsonProperty(value="defectLiabilityPeriod")
        public ContractBuilder defectLiabilityPeriod(BigDecimal defectLiabilityPeriod) {
            this.defectLiabilityPeriod = defectLiabilityPeriod;
            return this;
        }

        @JsonProperty(value="orgId")
        public ContractBuilder orgId(String orgId) {
            this.orgId = orgId;
            return this;
        }

        @JsonProperty(value="startDate")
        public ContractBuilder startDate(BigDecimal startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="endDate")
        public ContractBuilder endDate(BigDecimal endDate) {
            this.endDate = endDate;
            return this;
        }

        @JsonProperty(value="completionPeriod")
        public ContractBuilder completionPeriod(Integer completionPeriod) {
            this.completionPeriod = completionPeriod;
            return this;
        }

        @JsonProperty(value="status")
        public ContractBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="lineItems")
        public ContractBuilder lineItems(List<LineItems> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        @JsonProperty(value="documents")
        public ContractBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="processInstance")
        public ContractBuilder processInstance(ProcessInstance processInstance) {
            this.processInstance = processInstance;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ContractBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public ContractBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public Contract build() {
            return new Contract(this.id, this.contractNumber, this.supplementNumber, this.versionNumber, this.oldUuid, this.businessService, this.tenantId, this.wfStatus, this.executingAuthority, this.contractType, this.totalContractedAmount, this.securityDeposit, this.agreementDate, this.issueDate, this.defectLiabilityPeriod, this.orgId, this.startDate, this.endDate, this.completionPeriod, this.status, this.lineItems, this.documents, this.processInstance, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "Contract.ContractBuilder(id=" + this.id + ", contractNumber=" + this.contractNumber + ", supplementNumber=" + this.supplementNumber + ", versionNumber=" + this.versionNumber + ", oldUuid=" + this.oldUuid + ", businessService=" + this.businessService + ", tenantId=" + this.tenantId + ", wfStatus=" + this.wfStatus + ", executingAuthority=" + this.executingAuthority + ", contractType=" + this.contractType + ", totalContractedAmount=" + this.totalContractedAmount + ", securityDeposit=" + this.securityDeposit + ", agreementDate=" + this.agreementDate + ", issueDate=" + this.issueDate + ", defectLiabilityPeriod=" + this.defectLiabilityPeriod + ", orgId=" + this.orgId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", completionPeriod=" + this.completionPeriod + ", status=" + this.status + ", lineItems=" + this.lineItems + ", documents=" + this.documents + ", processInstance=" + this.processInstance + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

