/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.bankaccounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.models.Document;
import org.egov.works.services.common.models.bankaccounts.BankBranchIdentifier;

public class BankAccountDetails {
    @JsonProperty(value="id")
    @Valid
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="accountHolderName")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String accountHolderName = null;
    @JsonProperty(value="accountNumber")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String accountNumber = null;
    @JsonProperty(value="accountType")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String accountType = null;
    @JsonProperty(value="isPrimary")
    private Boolean isPrimary = true;
    @JsonProperty(value="bankBranchIdentifier")
    @NotNull
    @Valid
    private BankBranchIdentifier bankBranchIdentifier = null;
    @JsonProperty(value="isActive")
    private Boolean isActive = null;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="additionalFields")
    private Object additionalFields = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public BankAccountDetails addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public static BankAccountDetailsBuilder builder() {
        return new BankAccountDetailsBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public BankBranchIdentifier getBankBranchIdentifier() {
        return this.bankBranchIdentifier;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Object getAdditionalFields() {
        return this.additionalFields;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="accountHolderName")
    public void setAccountHolderName(String accountHolderName) {
        this.accountHolderName = accountHolderName;
    }

    @JsonProperty(value="accountNumber")
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    @JsonProperty(value="accountType")
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @JsonProperty(value="isPrimary")
    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @JsonProperty(value="bankBranchIdentifier")
    public void setBankBranchIdentifier(BankBranchIdentifier bankBranchIdentifier) {
        this.bankBranchIdentifier = bankBranchIdentifier;
    }

    @JsonProperty(value="isActive")
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(Object additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountDetails)) {
            return false;
        }
        BankAccountDetails other = (BankAccountDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isPrimary = this.getIsPrimary();
        Boolean other$isPrimary = other.getIsPrimary();
        if (this$isPrimary == null ? other$isPrimary != null : !((Object)this$isPrimary).equals(other$isPrimary)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$accountHolderName = this.getAccountHolderName();
        String other$accountHolderName = other.getAccountHolderName();
        if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
            return false;
        }
        String this$accountNumber = this.getAccountNumber();
        String other$accountNumber = other.getAccountNumber();
        if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
            return false;
        }
        String this$accountType = this.getAccountType();
        String other$accountType = other.getAccountType();
        if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
            return false;
        }
        BankBranchIdentifier this$bankBranchIdentifier = this.getBankBranchIdentifier();
        BankBranchIdentifier other$bankBranchIdentifier = other.getBankBranchIdentifier();
        if (this$bankBranchIdentifier == null ? other$bankBranchIdentifier != null : !((Object)this$bankBranchIdentifier).equals(other$bankBranchIdentifier)) {
            return false;
        }
        List<Document> this$documents = this.getDocuments();
        List<Document> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        Object this$additionalFields = this.getAdditionalFields();
        Object other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !this$additionalFields.equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccountDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isPrimary = this.getIsPrimary();
        result = result * 59 + ($isPrimary == null ? 43 : ((Object)$isPrimary).hashCode());
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $accountHolderName = this.getAccountHolderName();
        result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
        String $accountNumber = this.getAccountNumber();
        result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
        String $accountType = this.getAccountType();
        result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
        BankBranchIdentifier $bankBranchIdentifier = this.getBankBranchIdentifier();
        result = result * 59 + ($bankBranchIdentifier == null ? 43 : ((Object)$bankBranchIdentifier).hashCode());
        List<Document> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        Object $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : $additionalFields.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "BankAccountDetails(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", accountHolderName=" + this.getAccountHolderName() + ", accountNumber=" + this.getAccountNumber() + ", accountType=" + this.getAccountType() + ", isPrimary=" + this.getIsPrimary() + ", bankBranchIdentifier=" + this.getBankBranchIdentifier() + ", isActive=" + this.getIsActive() + ", documents=" + this.getDocuments() + ", additionalFields=" + this.getAdditionalFields() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public BankAccountDetails(String id, String tenantId, String accountHolderName, String accountNumber, String accountType, Boolean isPrimary, BankBranchIdentifier bankBranchIdentifier, Boolean isActive, List<Document> documents, Object additionalFields, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.accountHolderName = accountHolderName;
        this.accountNumber = accountNumber;
        this.accountType = accountType;
        this.isPrimary = isPrimary;
        this.bankBranchIdentifier = bankBranchIdentifier;
        this.isActive = isActive;
        this.documents = documents;
        this.additionalFields = additionalFields;
        this.auditDetails = auditDetails;
    }

    public BankAccountDetails() {
    }

    public static class BankAccountDetailsBuilder {
        private String id;
        private String tenantId;
        private String accountHolderName;
        private String accountNumber;
        private String accountType;
        private Boolean isPrimary;
        private BankBranchIdentifier bankBranchIdentifier;
        private Boolean isActive;
        private List<Document> documents;
        private Object additionalFields;
        private AuditDetails auditDetails;

        BankAccountDetailsBuilder() {
        }

        @JsonProperty(value="id")
        public BankAccountDetailsBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public BankAccountDetailsBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="accountHolderName")
        public BankAccountDetailsBuilder accountHolderName(String accountHolderName) {
            this.accountHolderName = accountHolderName;
            return this;
        }

        @JsonProperty(value="accountNumber")
        public BankAccountDetailsBuilder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @JsonProperty(value="accountType")
        public BankAccountDetailsBuilder accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @JsonProperty(value="isPrimary")
        public BankAccountDetailsBuilder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        @JsonProperty(value="bankBranchIdentifier")
        public BankAccountDetailsBuilder bankBranchIdentifier(BankBranchIdentifier bankBranchIdentifier) {
            this.bankBranchIdentifier = bankBranchIdentifier;
            return this;
        }

        @JsonProperty(value="isActive")
        public BankAccountDetailsBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @JsonProperty(value="documents")
        public BankAccountDetailsBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public BankAccountDetailsBuilder additionalFields(Object additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BankAccountDetailsBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public BankAccountDetails build() {
            return new BankAccountDetails(this.id, this.tenantId, this.accountHolderName, this.accountNumber, this.accountType, this.isPrimary, this.bankBranchIdentifier, this.isActive, this.documents, this.additionalFields, this.auditDetails);
        }

        public String toString() {
            return "BankAccountDetails.BankAccountDetailsBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", accountHolderName=" + this.accountHolderName + ", accountNumber=" + this.accountNumber + ", accountType=" + this.accountType + ", isPrimary=" + this.isPrimary + ", bankBranchIdentifier=" + this.bankBranchIdentifier + ", isActive=" + this.isActive + ", documents=" + this.documents + ", additionalFields=" + this.additionalFields + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

