/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.bankaccounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.bankaccounts.BankAccountDetails;

public class BankAccount {
    @JsonProperty(value="id")
    @Valid
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="serviceCode")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String serviceCode = null;
    @JsonProperty(value="referenceId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="bankAccountDetails")
    @Valid
    private List<BankAccountDetails> bankAccountDetails = null;
    @JsonProperty(value="additionalFields")
    private Object additionalFields = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public BankAccount addBankAccountDetailsItem(BankAccountDetails bankAccountDetailsItem) {
        if (this.bankAccountDetails == null) {
            this.bankAccountDetails = new ArrayList<BankAccountDetails>();
        }
        this.bankAccountDetails.add(bankAccountDetailsItem);
        return this;
    }

    public static BankAccountBuilder builder() {
        return new BankAccountBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public List<BankAccountDetails> getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    public Object getAdditionalFields() {
        return this.additionalFields;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="serviceCode")
    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="bankAccountDetails")
    public void setBankAccountDetails(List<BankAccountDetails> bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(Object additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccount)) {
            return false;
        }
        BankAccount other = (BankAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$serviceCode = this.getServiceCode();
        String other$serviceCode = other.getServiceCode();
        if (this$serviceCode == null ? other$serviceCode != null : !this$serviceCode.equals(other$serviceCode)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        List<BankAccountDetails> this$bankAccountDetails = this.getBankAccountDetails();
        List<BankAccountDetails> other$bankAccountDetails = other.getBankAccountDetails();
        if (this$bankAccountDetails == null ? other$bankAccountDetails != null : !((Object)this$bankAccountDetails).equals(other$bankAccountDetails)) {
            return false;
        }
        Object this$additionalFields = this.getAdditionalFields();
        Object other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !this$additionalFields.equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BankAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $serviceCode = this.getServiceCode();
        result = result * 59 + ($serviceCode == null ? 43 : $serviceCode.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        List<BankAccountDetails> $bankAccountDetails = this.getBankAccountDetails();
        result = result * 59 + ($bankAccountDetails == null ? 43 : ((Object)$bankAccountDetails).hashCode());
        Object $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : $additionalFields.hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "BankAccount(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", serviceCode=" + this.getServiceCode() + ", referenceId=" + this.getReferenceId() + ", bankAccountDetails=" + this.getBankAccountDetails() + ", additionalFields=" + this.getAdditionalFields() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public BankAccount(String id, String tenantId, String serviceCode, String referenceId, List<BankAccountDetails> bankAccountDetails, Object additionalFields, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.serviceCode = serviceCode;
        this.referenceId = referenceId;
        this.bankAccountDetails = bankAccountDetails;
        this.additionalFields = additionalFields;
        this.auditDetails = auditDetails;
    }

    public BankAccount() {
    }

    public static class BankAccountBuilder {
        private String id;
        private String tenantId;
        private String serviceCode;
        private String referenceId;
        private List<BankAccountDetails> bankAccountDetails;
        private Object additionalFields;
        private AuditDetails auditDetails;

        BankAccountBuilder() {
        }

        @JsonProperty(value="id")
        public BankAccountBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public BankAccountBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="serviceCode")
        public BankAccountBuilder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @JsonProperty(value="referenceId")
        public BankAccountBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="bankAccountDetails")
        public BankAccountBuilder bankAccountDetails(List<BankAccountDetails> bankAccountDetails) {
            this.bankAccountDetails = bankAccountDetails;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public BankAccountBuilder additionalFields(Object additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public BankAccountBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public BankAccount build() {
            return new BankAccount(this.id, this.tenantId, this.serviceCode, this.referenceId, this.bankAccountDetails, this.additionalFields, this.auditDetails);
        }

        public String toString() {
            return "BankAccount.BankAccountBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", serviceCode=" + this.serviceCode + ", referenceId=" + this.referenceId + ", bankAccountDetails=" + this.bankAccountDetails + ", additionalFields=" + this.additionalFields + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

