/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.attendance;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.attendance.IndividualEntry;

public class AttendeeCreateResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="attendees")
    @Valid
    private List<IndividualEntry> attendees = null;

    public AttendeeCreateResponse addAttendeesItem(IndividualEntry attendeesItem) {
        if (this.attendees == null) {
            this.attendees = new ArrayList<IndividualEntry>();
        }
        this.attendees.add(attendeesItem);
        return this;
    }

    public static AttendeeCreateResponseBuilder builder() {
        return new AttendeeCreateResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<IndividualEntry> getAttendees() {
        return this.attendees;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="attendees")
    public void setAttendees(List<IndividualEntry> attendees) {
        this.attendees = attendees;
    }

    public AttendeeCreateResponse(ResponseInfo responseInfo, List<IndividualEntry> attendees) {
        this.responseInfo = responseInfo;
        this.attendees = attendees;
    }

    public AttendeeCreateResponse() {
    }

    public static class AttendeeCreateResponseBuilder {
        private ResponseInfo responseInfo;
        private List<IndividualEntry> attendees;

        AttendeeCreateResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public AttendeeCreateResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="attendees")
        public AttendeeCreateResponseBuilder attendees(List<IndividualEntry> attendees) {
            this.attendees = attendees;
            return this;
        }

        public AttendeeCreateResponse build() {
            return new AttendeeCreateResponse(this.responseInfo, this.attendees);
        }

        public String toString() {
            return "AttendeeCreateResponse.AttendeeCreateResponseBuilder(responseInfo=" + this.responseInfo + ", attendees=" + this.attendees + ")";
        }
    }
}

