/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.attendance;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.works.services.common.models.attendance.IndividualEntry;
import org.egov.works.services.common.models.attendance.StaffPermission;
import org.egov.works.services.common.models.attendance.Status;

public class AttendanceRegister {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="registerNumber")
    private String registerNumber = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="referenceId")
    private String referenceId;
    @JsonProperty(value="serviceCode")
    private String serviceCode;
    @JsonProperty(value="startDate")
    private BigDecimal startDate = null;
    @JsonProperty(value="endDate")
    private BigDecimal endDate = null;
    @JsonProperty(value="status")
    private Status status = Status.ACTIVE;
    @JsonProperty(value="staff")
    @Valid
    private List<StaffPermission> staff = null;
    @JsonProperty(value="attendees")
    @Valid
    private List<IndividualEntry> attendees = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;

    public AttendanceRegister addStaffItem(StaffPermission staffItem) {
        if (this.staff == null) {
            this.staff = new ArrayList<StaffPermission>();
        }
        this.staff.add(staffItem);
        return this;
    }

    public AttendanceRegister addAttendeesItem(IndividualEntry attendeesItem) {
        if (this.attendees == null) {
            this.attendees = new ArrayList<IndividualEntry>();
        }
        this.attendees.add(attendeesItem);
        return this;
    }

    public static AttendanceRegisterBuilder builder() {
        return new AttendanceRegisterBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getRegisterNumber() {
        return this.registerNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public BigDecimal getStartDate() {
        return this.startDate;
    }

    public BigDecimal getEndDate() {
        return this.endDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<StaffPermission> getStaff() {
        return this.staff;
    }

    public List<IndividualEntry> getAttendees() {
        return this.attendees;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="registerNumber")
    public void setRegisterNumber(String registerNumber) {
        this.registerNumber = registerNumber;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="serviceCode")
    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(BigDecimal startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(BigDecimal endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="staff")
    public void setStaff(List<StaffPermission> staff) {
        this.staff = staff;
    }

    @JsonProperty(value="attendees")
    public void setAttendees(List<IndividualEntry> attendees) {
        this.attendees = attendees;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    public AttendanceRegister(String id, String tenantId, String registerNumber, String name, String referenceId, String serviceCode, BigDecimal startDate, BigDecimal endDate, Status status, List<StaffPermission> staff, List<IndividualEntry> attendees, AuditDetails auditDetails, Object additionalDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.registerNumber = registerNumber;
        this.name = name;
        this.referenceId = referenceId;
        this.serviceCode = serviceCode;
        this.startDate = startDate;
        this.endDate = endDate;
        this.status = status;
        this.staff = staff;
        this.attendees = attendees;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
    }

    public AttendanceRegister() {
    }

    public static class AttendanceRegisterBuilder {
        private String id;
        private String tenantId;
        private String registerNumber;
        private String name;
        private String referenceId;
        private String serviceCode;
        private BigDecimal startDate;
        private BigDecimal endDate;
        private Status status;
        private List<StaffPermission> staff;
        private List<IndividualEntry> attendees;
        private AuditDetails auditDetails;
        private Object additionalDetails;

        AttendanceRegisterBuilder() {
        }

        @JsonProperty(value="id")
        public AttendanceRegisterBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public AttendanceRegisterBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="registerNumber")
        public AttendanceRegisterBuilder registerNumber(String registerNumber) {
            this.registerNumber = registerNumber;
            return this;
        }

        @JsonProperty(value="name")
        public AttendanceRegisterBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="referenceId")
        public AttendanceRegisterBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="serviceCode")
        public AttendanceRegisterBuilder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @JsonProperty(value="startDate")
        public AttendanceRegisterBuilder startDate(BigDecimal startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="endDate")
        public AttendanceRegisterBuilder endDate(BigDecimal endDate) {
            this.endDate = endDate;
            return this;
        }

        @JsonProperty(value="status")
        public AttendanceRegisterBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="staff")
        public AttendanceRegisterBuilder staff(List<StaffPermission> staff) {
            this.staff = staff;
            return this;
        }

        @JsonProperty(value="attendees")
        public AttendanceRegisterBuilder attendees(List<IndividualEntry> attendees) {
            this.attendees = attendees;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public AttendanceRegisterBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public AttendanceRegisterBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public AttendanceRegister build() {
            return new AttendanceRegister(this.id, this.tenantId, this.registerNumber, this.name, this.referenceId, this.serviceCode, this.startDate, this.endDate, this.status, this.staff, this.attendees, this.auditDetails, this.additionalDetails);
        }

        public String toString() {
            return "AttendanceRegister.AttendanceRegisterBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", registerNumber=" + this.registerNumber + ", name=" + this.name + ", referenceId=" + this.referenceId + ", serviceCode=" + this.serviceCode + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", status=" + this.status + ", staff=" + this.staff + ", attendees=" + this.attendees + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ")";
        }
    }
}

