/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.attendance;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.works.services.common.models.attendance.AttendanceLog;

public class AttendanceLogResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="attendance")
    @Valid
    private List<AttendanceLog> attendance = null;

    public AttendanceLogResponse addAttendanceItem(AttendanceLog attendanceItem) {
        if (this.attendance == null) {
            this.attendance = new ArrayList<AttendanceLog>();
        }
        this.attendance.add(attendanceItem);
        return this;
    }

    public static AttendanceLogResponseBuilder builder() {
        return new AttendanceLogResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<AttendanceLog> getAttendance() {
        return this.attendance;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="attendance")
    public void setAttendance(List<AttendanceLog> attendance) {
        this.attendance = attendance;
    }

    public AttendanceLogResponse(ResponseInfo responseInfo, List<AttendanceLog> attendance) {
        this.responseInfo = responseInfo;
        this.attendance = attendance;
    }

    public AttendanceLogResponse() {
    }

    public static class AttendanceLogResponseBuilder {
        private ResponseInfo responseInfo;
        private List<AttendanceLog> attendance;

        AttendanceLogResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public AttendanceLogResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="attendance")
        public AttendanceLogResponseBuilder attendance(List<AttendanceLog> attendance) {
            this.attendance = attendance;
            return this;
        }

        public AttendanceLogResponse build() {
            return new AttendanceLogResponse(this.responseInfo, this.attendance);
        }

        public String toString() {
            return "AttendanceLogResponse.AttendanceLogResponseBuilder(responseInfo=" + this.responseInfo + ", attendance=" + this.attendance + ")";
        }
    }
}

