/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.services.common.models.attendance;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.works.services.common.models.attendance.AttendanceLog;

public class AttendanceLogRequest {
    @JsonProperty(value="RequestInfo")
    private RequestInfo requestInfo = null;
    @JsonProperty(value="attendance")
    @Valid
    private List<AttendanceLog> attendance = null;

    public AttendanceLogRequest addAttendanceItem(AttendanceLog attendanceItem) {
        if (this.attendance == null) {
            this.attendance = new ArrayList<AttendanceLog>();
        }
        this.attendance.add(attendanceItem);
        return this;
    }

    public static AttendanceLogRequestBuilder builder() {
        return new AttendanceLogRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<AttendanceLog> getAttendance() {
        return this.attendance;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="attendance")
    public void setAttendance(List<AttendanceLog> attendance) {
        this.attendance = attendance;
    }

    public AttendanceLogRequest(RequestInfo requestInfo, List<AttendanceLog> attendance) {
        this.requestInfo = requestInfo;
        this.attendance = attendance;
    }

    public AttendanceLogRequest() {
    }

    public static class AttendanceLogRequestBuilder {
        private RequestInfo requestInfo;
        private List<AttendanceLog> attendance;

        AttendanceLogRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public AttendanceLogRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="attendance")
        public AttendanceLogRequestBuilder attendance(List<AttendanceLog> attendance) {
            this.attendance = attendance;
            return this;
        }

        public AttendanceLogRequest build() {
            return new AttendanceLogRequest(this.requestInfo, this.attendance);
        }

        public String toString() {
            return "AttendanceLogRequest.AttendanceLogRequestBuilder(requestInfo=" + this.requestInfo + ", attendance=" + this.attendance + ")";
        }
    }
}

