/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class KafkaTemplateLoggingInterceptors<K, V>
implements ConsumerInterceptor<K, V>,
ProducerInterceptor<K, V> {
    private static final Logger log = LoggerFactory.getLogger(KafkaTemplateLoggingInterceptors.class);
    private static final String EMPTY_BODY = "<EMPTY BODY>";
    private static final String SEND_SUCCESS_MESSAGE = "Sending message to topic: {}, partition: {} with key: {} .";
    private static final String BODY_JSON_SERIALIZATION_ERROR = "Serialization of body failed while attempting to log the body";
    private static final String SEND_SUCCESS_MESSAGE_WITH_BODY = "Sending message to topic: {}, partition: {}, body: {} with key: {} .";
    private static final String SEND_FAILURE_MESSAGE = "Sending of message to topic: %s, partition %s failed.";
    private static final String RECEIVED_MESSAGE_WITH_BODY = "Received message from topic: {}, partition: {}, body: {} with key: {}";
    private static final String RECEIVED_MESSAGE = "Received message from topic: {}, partition: {}, with key: {}";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> consumerRecords) {
        for (ConsumerRecord consumerRecord : consumerRecords) {
            String keyAsString = ObjectUtils.nullSafeToString((Object)consumerRecord.key());
            String correlationId = this.getCorrelationIdFromBody(consumerRecord.value());
            if (!StringUtils.isEmpty((Object)correlationId)) {
                MDC.put((String)"CORRELATION_ID", (String)correlationId);
            }
            if (log.isDebugEnabled()) {
                String bodyAsJsonString = this.getMessageBodyAsJsonString(consumerRecord.value());
                log.debug(RECEIVED_MESSAGE_WITH_BODY, new Object[]{consumerRecord.topic(), consumerRecord.partition(), bodyAsJsonString, keyAsString});
                continue;
            }
            log.info(RECEIVED_MESSAGE, new Object[]{consumerRecord.topic(), consumerRecord.topic(), consumerRecord.key()});
        }
        return consumerRecords;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> map) {
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> producerRecord) {
        String keyAsString = ObjectUtils.nullSafeToString((Object)producerRecord.key());
        if (log.isDebugEnabled()) {
            String bodyAsJsonString = this.getMessageBodyAsJsonString(producerRecord.value());
            log.debug(SEND_SUCCESS_MESSAGE_WITH_BODY, new Object[]{producerRecord.topic(), producerRecord.partition(), bodyAsJsonString, keyAsString});
        } else {
            log.info(SEND_SUCCESS_MESSAGE, new Object[]{producerRecord.topic(), producerRecord.partition(), keyAsString});
        }
        return producerRecord;
    }

    public void onAcknowledgement(RecordMetadata recordMetadata, Exception e) {
        if (!Objects.isNull(e)) {
            String message = String.format(SEND_FAILURE_MESSAGE, recordMetadata.topic(), recordMetadata.partition());
            log.error(message, (Throwable)e);
        }
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }

    private String getMessageBodyAsJsonString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            log.warn(BODY_JSON_SERIALIZATION_ERROR);
            return EMPTY_BODY;
        }
    }

    private String getCorrelationIdFromBody(Object value) {
        String correlationId = null;
        try {
            Object requestInfo;
            Map requestMap = (Map)this.objectMapper.convertValue(value, Map.class);
            Object v = requestInfo = requestMap.containsKey("RequestInfo") ? requestMap.get("RequestInfo") : requestMap.get("requestInfo");
            if (Objects.isNull(requestInfo)) {
                return null;
            }
            if (requestInfo instanceof Map) {
                correlationId = (String)((Map)requestInfo).get("correlationId");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return correlationId;
    }
}

