/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.apache.kafka.common.errors.SerializationException;
import org.egov.tracer.config.ObjectMapperFactory;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.model.ErrorDetailDTO;
import org.egov.tracer.model.ErrorQueueContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class ErrorQueueProducer {
    private static final Logger log = LoggerFactory.getLogger(ErrorQueueProducer.class);
    @Autowired
    private KafkaTemplate<String, Object> kafkaTemplate;
    @Autowired
    private TracerProperties tracerProperties;
    @Autowired
    private ObjectMapperFactory objectMapperFactory;

    public void sendMessage(ErrorQueueContract errorQueueContract) {
        try {
            log.info("Sending message to topic - " + this.tracerProperties.getErrorsTopic());
            this.kafkaTemplate.send(this.tracerProperties.getErrorsTopic(), (Object)errorQueueContract);
        }
        catch (SerializationException serializationException) {
            log.info("SerializationException exception occurred while sending exception to error queue");
            try {
                this.kafkaTemplate.send(this.tracerProperties.getErrorsTopic(), (Object)this.objectMapperFactory.getObjectMapper().writeValueAsString((Object)errorQueueContract));
            }
            catch (JsonProcessingException e) {
                log.info("exception occurred while converting ErrorQueueContract to json string");
            }
        }
        catch (Exception ex) {
            log.error("exception occurred while sending exception to error queue");
        }
    }

    public void sendErrorDetails(List<ErrorDetailDTO> errorDetailList) {
        try {
            log.info("Sending message to topic - error-details-indexer-topic");
            this.kafkaTemplate.send(this.tracerProperties.getErrorDetailsTopic(), errorDetailList);
        }
        catch (SerializationException serializationException) {
            log.info("SerializationException exception occurred while sending exception to error queue");
            try {
                this.kafkaTemplate.send(this.tracerProperties.getErrorDetailsTopic(), (Object)this.objectMapperFactory.getObjectMapper().writeValueAsString(errorDetailList));
            }
            catch (JsonProcessingException e) {
                log.info("exception occurred while converting error details to json string");
            }
        }
        catch (Exception ex) {
            log.error("exception occurred while sending exception to error queue");
        }
    }
}

