/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.egov.tracer.ExceptionAdvise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class KafkaConsumerErrorHandler
extends DefaultErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerErrorHandler.class);
    @Autowired
    private ExceptionAdvise exceptionAdvise;
    @Value(value="${tracer.errorsPublish}")
    private boolean sendErrorsToKafka;

    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (this.sendErrorsToKafka) {
            records.forEach(record -> {
                log.error("Error while processing1: " + ObjectUtils.nullSafeToString((Object)record), (Throwable)thrownException);
                ObjectMapper objectMapper = new ObjectMapper();
                String body = null;
                try {
                    body = objectMapper.writeValueAsString(record.value());
                }
                catch (Exception ex) {
                    log.error("KafkaConsumerErrorHandller Kafka consumer can not parse json data " + ex.getMessage());
                }
                this.exceptionAdvise.sendErrorMessage(body, thrownException, record.topic(), false);
            });
        }
    }
}

