/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http.filters;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.ObjectMapperFactory;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.filters.MultiReadRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.ObjectUtils;

public class TracerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(TracerFilter.class);
    private static final List<String> JSON_MEDIA_TYPES = Arrays.asList("application/json");
    private static final String POST = "POST";
    private static final String REQUEST_BODY_LOG_MESSAGE = "Request body - {}";
    private static final String FAILED_TO_LOG_REQUEST_MESSAGE = "Failed to log request body";
    private static final String UTF_8 = "UTF-8";
    private static final String REQUEST_URI_LOG_MESSAGE = "Received request URI: {} ";
    private static final String REQUEST_PARAMS_LOG_MESSAGE = "Request Query params: {} ";
    private static final String LOG_RESPONSE_CODE_MESSAGE = "Response code sent: {}";
    private final ObjectMapper objectMapper;
    private TracerProperties tracerProperties;
    private Pattern skipPattern;

    public TracerFilter(TracerProperties tracerProperties, ObjectMapperFactory objectMapperFactory) {
        this.tracerProperties = tracerProperties;
        this.objectMapper = objectMapperFactory.getObjectMapper();
        this.skipPattern = Objects.isNull(tracerProperties.getFilterSkipPattern()) ? null : Pattern.compile(tracerProperties.getFilterSkipPattern());
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        if (!this.isTraced(httpRequest)) {
            filterChain.doFilter((ServletRequest)httpRequest, servletResponse);
        } else {
            if (this.isBodyCompatibleForParsing(httpRequest)) {
                MultiReadRequestWrapper wrappedRequest = new MultiReadRequestWrapper(httpRequest);
                Map<String, String> headerParamMap = this.getCorrelationId((HttpServletRequest)wrappedRequest);
                MDC.put((String)"CORRELATION_ID", (String)headerParamMap.get("CORRELATION_ID"));
                MDC.put((String)"TENANTID", (String)headerParamMap.get("TENANTID"));
                this.logRequestURI(httpRequest);
                if (this.tracerProperties.isRequestLoggingEnabled()) {
                    this.logRequestBodyAndParams((HttpServletRequest)wrappedRequest);
                }
                filterChain.doFilter((ServletRequest)wrappedRequest, servletResponse);
            } else {
                Map<String, String> headerParamMap = this.getCorrelationId(httpRequest);
                MDC.put((String)"CORRELATION_ID", (String)headerParamMap.get("CORRELATION_ID"));
                MDC.put((String)"TENANTID", (String)headerParamMap.get("TENANTID"));
                this.logRequestURI(httpRequest);
                filterChain.doFilter((ServletRequest)httpRequest, servletResponse);
            }
            this.logResponse(servletResponse);
        }
    }

    public void destroy() {
        MDC.clear();
    }

    private boolean isTraced(HttpServletRequest httpServletRequest) {
        if (this.skipPattern != null) {
            String url = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
            return !this.skipPattern.matcher(url).matches();
        }
        return true;
    }

    private void logResponse(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        log.info(LOG_RESPONSE_CODE_MESSAGE, (Object)httpServletResponse.getStatus());
    }

    private void logRequestURI(HttpServletRequest httpRequest) {
        String url = httpRequest.getRequestURL().toString();
        log.info(REQUEST_URI_LOG_MESSAGE, (Object)url);
    }

    private Map<String, String> getCorrelationId(HttpServletRequest httpRequest) {
        return this.getParamMapFromHeader(httpRequest);
    }

    private boolean isBodyCompatibleForParsing(HttpServletRequest httpRequest) {
        return POST.equals(httpRequest.getMethod()) && JSON_MEDIA_TYPES.contains(httpRequest.getContentType());
    }

    private void logRequestBodyAndParams(HttpServletRequest requestWrapper) {
        try {
            String requestBody = IOUtils.toString((InputStream)requestWrapper.getInputStream(), (String)UTF_8);
            ServletInputStream inputStream = requestWrapper.getInputStream();
            String requestParams = requestWrapper.getQueryString();
            if (!ObjectUtils.isEmpty((Object)requestParams)) {
                log.info(REQUEST_PARAMS_LOG_MESSAGE, (Object)requestParams);
            }
            if (!ObjectUtils.isEmpty((Object)requestBody)) {
                log.info(REQUEST_BODY_LOG_MESSAGE, (Object)requestBody);
            }
        }
        catch (IOException e) {
            log.error(FAILED_TO_LOG_REQUEST_MESSAGE, (Throwable)e);
        }
    }

    private Map<String, String> getParamMapFromHeader(HttpServletRequest httpRequest) {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        String correlationId = httpRequest.getHeader("x-correlation-id");
        if (Objects.isNull(correlationId) && httpRequest instanceof MultiReadRequestWrapper) {
            correlationId = this.getCorrelationIdFromBody(httpRequest);
        }
        if (Objects.isNull(correlationId)) {
            correlationId = this.getRandomCorrelationId();
        }
        keyMap.put("CORRELATION_ID", correlationId);
        keyMap.put("TENANTID", httpRequest.getHeader("tenantId"));
        return keyMap;
    }

    private String getCorrelationIdFromBody(HttpServletRequest httpServletRequest) {
        String correlationId = null;
        try {
            Object requestInfo;
            HashMap requestMap = (HashMap)this.objectMapper.readValue((InputStream)httpServletRequest.getInputStream(), HashMap.class);
            Object v = requestInfo = requestMap.containsKey("RequestInfo") ? requestMap.get("RequestInfo") : requestMap.get("requestInfo");
            if (Objects.isNull(requestInfo)) {
                return null;
            }
            if (requestInfo instanceof Map) {
                correlationId = (String)((Map)requestInfo).get("correlationId");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return correlationId;
    }

    private String getRandomCorrelationId() {
        return UUID.randomUUID().toString();
    }
}

