/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http.filters;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiReadRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(MultiReadRequestWrapper.class);
    private ByteArrayOutputStream cachedBytes;

    MultiReadRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedBytes == null) {
            this.cacheInputStream();
        }
        return new CachedServletInputStream();
    }

    public void update(ByteArrayOutputStream newBytes) {
        this.cachedBytes = newBytes;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void cacheInputStream() throws IOException {
        this.cachedBytes = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)super.getInputStream(), (OutputStream)this.cachedBytes);
    }

    public class CachedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream input;

        CachedServletInputStream() {
            this.input = new ByteArrayInputStream(MultiReadRequestWrapper.this.cachedBytes.toByteArray());
        }

        public boolean isFinished() {
            return this.input.available() != 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.input.read();
        }
    }
}

