/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.TracerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.CollectionUtils;

public class RestTemplateLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateLoggingInterceptor.class);
    private static final String REQUEST_MESSAGE_WITH_BODY = "Sending request to {} with verb {} with body {}";
    private static final String REQUEST_MESSAGE = "Sending request to {} with verb {}";
    private static final String RESPONSE_MESSAGE_WITH_BODY = "Received from {} response code {} and body {}: ";
    private static final String RESPONSE_MESSAGE = "Received response from {}";
    private static final String FAILED_RESPONSE_MESSAGE = "Received error response from %s";
    private static final String UTF_8 = "UTF-8";
    private static final String RESPONSE_BODY_ERROR_MESSAGE = "Error reading response body";
    private static final String EMPTY_BODY = "<NOT-AVAILABLE>";
    private static final List<String> JSON_MEDIA_TYPES = Arrays.asList("application/json;charset=UTF-8", "application/json");
    private TracerProperties tracerProperties;

    public RestTemplateLoggingInterceptor(TracerProperties tracerProperties) {
        this.tracerProperties = tracerProperties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            request.getHeaders().add("x-correlation-id", MDC.get((String)"CORRELATION_ID"));
            List tenantId = request.getHeaders().get((Object)"tenantId");
            if (CollectionUtils.isEmpty((Collection)tenantId)) {
                request.getHeaders().add("tenantId", MDC.get((String)"TENANTID"));
            }
            this.logRequest(request, body);
            ClientHttpResponse rawResponse = execution.execute(request, body);
            if (this.tracerProperties.isRestTemplateDetailedLoggingEnabled() && this.isBodyCompatibleForParsing((HttpMessage)request)) {
                this.logResponse(rawResponse, request);
            } else {
                log.info(RESPONSE_MESSAGE, (Object)request.getURI());
            }
            return rawResponse;
        }
        catch (Exception e) {
            log.warn(String.format(FAILED_RESPONSE_MESSAGE, request.getURI()), (Throwable)e);
            throw e;
        }
    }

    private void logResponse(ClientHttpResponse response, HttpRequest httpRequest) throws IOException {
        if (this.tracerProperties.isRestTemplateDetailedLoggingEnabled() && this.isBodyCompatibleForParsing((HttpMessage)httpRequest)) {
            String body = this.getBodyString(response);
            log.info(RESPONSE_MESSAGE_WITH_BODY, new Object[]{httpRequest.getURI(), response.getStatusCode(), body});
        } else {
            log.info(RESPONSE_MESSAGE, (Object)httpRequest.getURI());
        }
    }

    private void logRequest(HttpRequest httpRequest, byte[] body) {
        if (this.tracerProperties.isRestTemplateDetailedLoggingEnabled() && this.isBodyCompatibleForParsing((HttpMessage)httpRequest)) {
            log.info(REQUEST_MESSAGE_WITH_BODY, new Object[]{httpRequest.getURI(), httpRequest.getMethod().name(), this.getBody(body)});
        } else {
            log.info(REQUEST_MESSAGE, (Object)httpRequest.getURI(), (Object)httpRequest.getMethod().name());
        }
    }

    private String getBody(byte[] body) {
        return body == null ? EMPTY_BODY : new String(body);
    }

    private boolean isBodyCompatibleForParsing(HttpMessage httpMessage) {
        MediaType contentType = httpMessage.getHeaders().getContentType();
        return contentType != null && JSON_MEDIA_TYPES.contains(contentType.toString());
    }

    private String getBodyString(ClientHttpResponse response) {
        try {
            if (response != null && response.getBody() != null) {
                InputStream bodyStream = response.getBody();
                return IOUtils.toString((InputStream)response.getBody(), (String)UTF_8);
            }
            return EMPTY_BODY;
        }
        catch (IOException e) {
            log.error(RESPONSE_BODY_ERROR_MESSAGE, (Throwable)e);
            return EMPTY_BODY;
        }
    }
}

