/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.filters.MultiReadRequestWrapper;
import org.egov.tracer.kafka.ErrorQueueProducer;
import org.egov.tracer.model.ApiDetails;
import org.egov.tracer.model.AuditDetails;
import org.egov.tracer.model.CustomBindingResultExceprion;
import org.egov.tracer.model.CustomException;
import org.egov.tracer.model.Error;
import org.egov.tracer.model.ErrorDetail;
import org.egov.tracer.model.ErrorDetailDTO;
import org.egov.tracer.model.ErrorEntity;
import org.egov.tracer.model.ErrorQueueContract;
import org.egov.tracer.model.ErrorRes;
import org.egov.tracer.model.ErrorType;
import org.egov.tracer.model.ServiceCallException;
import org.egov.tracer.model.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.ResourceAccessException;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
@EnableConfigurationProperties(value={TracerProperties.class})
public class ExceptionAdvise {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvise.class);
    @Value(value="${tracer.errors.provideExceptionInDetails:false}")
    private boolean provideExceptionInDetails;
    @Autowired
    private ErrorQueueProducer errorQueueProducer;
    @Autowired
    private TracerProperties tracerProperties;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<?> exceptionHandler(HttpServletRequest request, Exception ex) {
        String contentType = request.getContentType();
        boolean isJsonContentType = contentType != null && contentType.toLowerCase().contains("application/json");
        log.error("Exception caught in tracer ", (Throwable)ex);
        String body = "";
        try {
            if (request instanceof MultiReadRequestWrapper) {
                ServletInputStream stream = request.getInputStream();
                body = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            } else {
                body = "Unable to retrieve request body";
            }
        }
        catch (IOException ignored) {
            body = "Unable to retrieve request body";
        }
        ErrorRes errorRes = new ErrorRes();
        ArrayList<Error> errors = new ArrayList<Error>();
        try {
            Error err;
            if (ex instanceof HttpMediaTypeNotSupportedException) {
                errorRes.setErrors(new ArrayList<Error>(Collections.singletonList(new Error("UnsupportedMediaType", "An unsupported media Type was used - " + request.getContentType(), null, null))));
            } else if (ex instanceof ResourceAccessException) {
                err = new Error();
                err.setCode("ResourceAccessError");
                err.setMessage("An error occurred while accessing a underlying resource");
                errors.add(err);
                errorRes.setErrors(errors);
            } else if (ex instanceof HttpMessageNotReadableException) {
                err = new Error();
                String message = ex.getMessage();
                if (ex.getCause() instanceof JsonMappingException) {
                    Pattern pattern = Pattern.compile("(.+)Can not deserialize instance of ([a-z]+\\.){1,}(?<objecttype>[^ ]+).*\\[\"(?<objectname>[^\"]+)\"\\].*", 34);
                    Matcher match = pattern.matcher(message);
                    boolean matched = match.find();
                    if (matched) {
                        err.setMessage("Failed to parse field - " + match.group("objectname") + ". Expected type is " + match.group("objecttype"));
                    } else {
                        err.setMessage("Failed to deserialize certain JSON fields");
                    }
                    err.setCode("JsonMappingException");
                } else if (ex.getCause() instanceof JsonParseException) {
                    err.setCode("JsonParseException");
                    message = ex.getCause().getMessage().replaceAll("Source: [^;]+; ", "").replaceAll(" \\(code \\d+\\)", "").replaceAll("\\n", "");
                    err.setMessage(message);
                } else {
                    try {
                        err.setMessage("JSON body has errors or is missing");
                        JsonPath.parse((Object)request).json();
                    }
                    catch (Exception jsonParseException) {
                        log.error("Error while parsing JSON", (Throwable)jsonParseException);
                    }
                    err.setCode("MissingJsonException");
                }
                errors.add(err);
                errorRes.setErrors(errors);
            } else if (ex instanceof MethodArgumentNotValidException) {
                MethodArgumentNotValidException argumentNotValidException = (MethodArgumentNotValidException)ex;
                errorRes.setErrors(this.getBindingErrors(argumentNotValidException.getBindingResult(), errors));
            } else if (ex instanceof CustomBindingResultExceprion) {
                CustomBindingResultExceprion customBindingResultExceprion = (CustomBindingResultExceprion)ex;
                errorRes.setErrors(this.getBindingErrors(customBindingResultExceprion.getBindingResult(), errors));
            } else if (ex instanceof CustomException) {
                CustomException customException = (CustomException)ex;
                this.populateCustomErrors(customException, errors);
                errorRes.setErrors(errors);
            } else {
                if (ex instanceof ServiceCallException) {
                    ServiceCallException serviceCallException = (ServiceCallException)ex;
                    this.sendErrorMessage(body, ex, request.getRequestURL().toString(), errorRes, isJsonContentType);
                    if (this.tracerProperties.isShouldPublishErrorDetailsFlag()) {
                        this.prepareErrorDetailsAndInvokeExceptionHandler(request, ex);
                    }
                    DocumentContext documentContext = JsonPath.parse((String)serviceCallException.getError());
                    LinkedHashMap linkedHashMap = (LinkedHashMap)documentContext.json();
                    return new ResponseEntity((Object)linkedHashMap, HttpStatus.BAD_REQUEST);
                }
                if (ex instanceof MissingServletRequestParameterException) {
                    MissingServletRequestParameterException exception = (MissingServletRequestParameterException)ex;
                    Error error = new Error();
                    error.setCode("");
                    error.setMessage(exception.getMessage());
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(exception.getParameterName());
                    error.setParams(params);
                    errors.add(error);
                    errorRes.setErrors(errors);
                } else if (ex instanceof BindException) {
                    BindException bindException = (BindException)ex;
                    errorRes.setErrors(this.getBindingErrors(bindException.getBindingResult(), errors));
                }
            }
            String exceptionName = ex.getClass().getSimpleName();
            String exceptionMessage = ex.getMessage();
            if (errorRes.getErrors() == null || errorRes.getErrors().size() == 0) {
                errorRes.setErrors(new ArrayList<Error>(Collections.singletonList(new Error(exceptionName, "An unhandled exception occurred on the server", exceptionMessage, null))));
                if (this.tracerProperties.isShouldPublishErrorDetailsFlag()) {
                    this.prepareErrorDetailsAndInvokeExceptionHandler(request, ex);
                }
            } else if (this.provideExceptionInDetails && errorRes.getErrors() != null && errorRes.getErrors().size() > 0) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                errorRes.getErrors().get(0).setDescription(sw.toString());
            }
            this.sendErrorMessage(body, ex, request.getRequestURL().toString(), errorRes, isJsonContentType);
        }
        catch (Exception tracerException) {
            log.error("Error in tracer", (Throwable)tracerException);
            errorRes.setErrors(new ArrayList<Error>(Collections.singletonList(new Error("TracerException", "An unhandled exception occurred in tracer handler", null, null))));
        }
        return new ResponseEntity((Object)errorRes, HttpStatus.BAD_REQUEST);
    }

    public void exceptionHandler(List<ErrorDetail> errorDetails) {
        errorDetails.forEach(errorDetail -> errorDetail.getErrors().forEach(errorEntity -> {
            Exception ex = errorEntity.getException();
            log.error("Exception caught in tracer ", (Throwable)ex);
        }));
        ArrayList<ErrorDetailDTO> errorDetailsForIndexing = new ArrayList<ErrorDetailDTO>();
        AuditDetails auditDetails = AuditDetails.builder().createdTime(System.currentTimeMillis()).lastModifiedTime(System.currentTimeMillis()).build();
        errorDetails.forEach(errorDetail -> {
            ErrorDetailDTO errorDetailDTO = new ErrorDetailDTO();
            BeanUtils.copyProperties((Object)errorDetail, (Object)errorDetailDTO);
            errorDetailDTO.setAuditDetails(auditDetails);
            errorDetailDTO.setStatus(Status.PENDING);
            if (ObjectUtils.isEmpty((Object)errorDetailDTO.getApiDetails().getId())) {
                errorDetailDTO.setUuid(UUID.randomUUID().toString());
                errorDetailDTO.setRetryCount(0);
            } else {
                errorDetailDTO.setUuid(errorDetailDTO.getApiDetails().getId());
            }
            errorDetailsForIndexing.add(errorDetailDTO);
        });
        this.errorQueueProducer.sendErrorDetails(errorDetailsForIndexing);
    }

    private void prepareErrorDetailsAndInvokeExceptionHandler(HttpServletRequest request, Exception ex) {
        String contentType = request.getContentType();
        String body = "";
        try {
            if (request instanceof MultiReadRequestWrapper) {
                ServletInputStream stream = request.getInputStream();
                body = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            } else {
                body = "Unable to retrieve request body";
            }
        }
        catch (IOException ignored) {
            body = "Unable to retrieve request body";
        }
        ApiDetails apiDetails = new ApiDetails();
        apiDetails.setRequestBody(body);
        apiDetails.setContentType(contentType);
        apiDetails.setUrl(request.getRequestURL().toString());
        ErrorEntity errorEntity = new ErrorEntity();
        errorEntity.setErrorType(ErrorType.RECOVERABLE);
        errorEntity.setErrorMessage(ex.getMessage());
        errorEntity.setErrorCode("UNHANDLED_EXCEPTION_ERROR");
        errorEntity.setException(ex);
        ErrorDetail errorDetail = new ErrorDetail();
        errorDetail.setApiDetails(apiDetails);
        errorDetail.setErrors(Collections.singletonList(errorEntity));
        this.exceptionHandler(Collections.singletonList(errorDetail));
    }

    private List<Error> getBindingErrors(BindingResult bindingResult, List<Error> errors) {
        List objectErrors = bindingResult.getAllErrors();
        for (ObjectError objectError : objectErrors) {
            Error error = new Error();
            String[] codes = objectError.getCodes();
            error.setCode(codes[0]);
            error.setMessage(objectError.getDefaultMessage());
            errors.add(error);
        }
        return errors;
    }

    private void populateCustomErrors(CustomException customException, List<Error> errors) {
        Map<String, String> map = customException.getErrors();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Error error = new Error();
                error.setCode(entry.getKey());
                error.setMessage(entry.getValue());
                errors.add(error);
            }
        } else {
            Error error = new Error();
            error.setCode(customException.getCode());
            error.setMessage(customException.getMessage());
            errors.add(error);
        }
    }

    void sendErrorMessage(String body, Exception ex, String source, boolean isJsonContentType) {
        if (this.tracerProperties.isErrorsPublish()) {
            Object requestBody = body;
            if (isJsonContentType) {
                try {
                    DocumentContext documentContext = JsonPath.parse((String)body);
                    requestBody = documentContext.json();
                }
                catch (Exception exception) {
                    requestBody = body;
                }
            }
            StackTraceElement[] elements = ex.getStackTrace();
            ErrorQueueContract errorQueueContract = ErrorQueueContract.builder().id(UUID.randomUUID().toString()).correlationId(MDC.get((String)"CORRELATION_ID")).body(requestBody).source(source).ts(new Date().getTime()).exception(Arrays.asList(elements)).message(ex.getMessage()).build();
            this.errorQueueProducer.sendMessage(errorQueueContract);
        }
    }

    void sendErrorMessage(String body, Exception ex, String source, ErrorRes errorRes, boolean isJsonContentType) {
        if (this.tracerProperties.isErrorsPublish()) {
            Object requestBody = body;
            if (isJsonContentType) {
                try {
                    DocumentContext documentContext = JsonPath.parse((String)body);
                    requestBody = documentContext.json();
                }
                catch (Exception exception) {
                    requestBody = body;
                }
            }
            StackTraceElement[] elements = ex.getStackTrace();
            ErrorQueueContract errorQueueContract = ErrorQueueContract.builder().id(UUID.randomUUID().toString()).correlationId(MDC.get((String)"CORRELATION_ID")).body(requestBody).source(source).ts(new Date().getTime()).errorRes(errorRes).exception(Arrays.asList(elements)).message(ex.getMessage()).build();
            this.errorQueueProducer.sendMessage(errorQueueContract);
        }
    }
}

