/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.config;

import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import java.util.Collections;
import javax.servlet.Filter;
import org.egov.tracer.config.ObjectMapperFactory;
import org.egov.tracer.config.OpenTracingConfiguration;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.RestTemplateLoggingInterceptor;
import org.egov.tracer.http.filters.TracerFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableAspectJAutoProxy
@ComponentScan(basePackages={"org.egov.tracer"})
@PropertySource(value={"classpath:tracer.properties"})
@EnableConfigurationProperties(value={TracerProperties.class})
@Import(value={OpenTracingConfiguration.class})
public class TracerConfiguration {
    @Bean
    public ObjectMapperFactory objectMapperFactory(TracerProperties tracerProperties, Environment environment) {
        return new ObjectMapperFactory(tracerProperties, environment);
    }

    @Bean(name={"logAwareRestTemplate"})
    public RestTemplate logAwareRestTemplate(TracerProperties tracerProperties) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setOutputStreaming(false);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)requestFactory));
        restTemplate.setInterceptors(Collections.singletonList(new RestTemplateLoggingInterceptor(tracerProperties)));
        return restTemplate;
    }

    @Bean
    @ConditionalOnProperty(name={"tracer.filter.enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean tracerFilter(ObjectMapperFactory objectMapperFactory, TracerProperties tracerProperties) {
        TracerFilter tracerFilter = new TracerFilter(tracerProperties, objectMapperFactory);
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)tracerFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("TracerFilter");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"tracer.opentracing.enabled"}, havingValue="false", matchIfMissing=true)
    public Tracer tracer() {
        return NoopTracerFactory.create();
    }
}

