/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.egov.tracer.ExceptionAdvise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.listener.LoggingErrorHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class KafkaConsumerErrorHandller
extends LoggingErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerErrorHandller.class);
    @Autowired
    private ExceptionAdvise exceptionAdvise;
    @Value(value="${tracer.errors.sendToKafka:true}")
    boolean sendErrorsToKafka;

    public void handle(Exception thrownException, ConsumerRecord<?, ?> record) {
        if (this.sendErrorsToKafka) {
            log.error("Error while processing1: " + ObjectUtils.nullSafeToString(record), (Throwable)thrownException);
            ObjectMapper objectMapper = new ObjectMapper();
            String body = null;
            try {
                body = objectMapper.writeValueAsString(record.value());
            }
            catch (Exception ex) {
                log.error("KafkaConsumerErrorHandller Kafka consumer can not parse json data");
                ex.printStackTrace();
            }
            this.exceptionAdvise.sendErrorMessage(body, thrownException, record.topic(), null, false);
        }
    }
}

