/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.http.CacheableSimpleClientHttpResponse;
import org.egov.tracer.model.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class LogAwareRestTemplate
extends RestTemplate {
    private static final Logger log = LoggerFactory.getLogger(LogAwareRestTemplate.class);
    private static final String REQUEST_MESSAGE_WITH_BODY = "Sending request to {} with verb {} with body {}";
    private static final String REQUEST_MESSAGE = "Sending request to {} with verb {}";
    private static final String RESPONSE_MESSAGE_WITH_BODY = "Received from {} response code {} and body {}: ";
    private static final String RESPONSE_MESSAGE = "Received response from {}";
    private static final String FAILED_RESPONSE_MESSAGE = "Received error response from %s";
    private static final String UTF_8 = "UTF-8";
    private static final String RESPONSE_BODY_ERROR_MESSAGE = "Error reading response body";
    private static final String RESPONSE_CODE_ERROR_MESSAGE = "Error reading response code";
    private static final String EMPTY_BODY = "<NOT-AVAILABLE>";
    private static final List<String> JSON_MEDIA_TYPES = Arrays.asList("application/json;charset=UTF-8", "application/json");
    private TracerProperties tracerProperties;

    public LogAwareRestTemplate(TracerProperties tracerProperties) {
        this.tracerProperties = tracerProperties;
        this.setInterceptors(Collections.singletonList(this.logRequestAndResponse()));
    }

    private void addCorrelationIdHeader(HttpRequest httpRequest) {
        httpRequest.getHeaders().add("x-correlation-id", RequestContext.getId());
    }

    private ClientHttpRequestInterceptor logRequestAndResponse() {
        return (httpRequest, body, clientHttpRequestExecution) -> {
            this.addCorrelationIdHeader(httpRequest);
            this.logRequest(httpRequest, body);
            return this.executeAndLogResponse(httpRequest, body, clientHttpRequestExecution);
        };
    }

    private ClientHttpResponse executeAndLogResponse(HttpRequest httpRequest, byte[] body, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        try {
            ClientHttpResponse rawResponse = clientHttpRequestExecution.execute(httpRequest, body);
            if (this.tracerProperties.isDetailedTracingDisabled() || this.isBodyNotCompatibleForParsing((HttpMessage)httpRequest)) {
                log.info(RESPONSE_MESSAGE, (Object)httpRequest.getURI());
                return rawResponse;
            }
            CacheableSimpleClientHttpResponse response = new CacheableSimpleClientHttpResponse(rawResponse);
            this.logResponse((ClientHttpResponse)response, httpRequest.getURI());
            return response;
        }
        catch (Exception e) {
            log.error(String.format(FAILED_RESPONSE_MESSAGE, httpRequest.getURI()), (Throwable)e);
            throw e;
        }
    }

    private boolean isBodyNotCompatibleForParsing(HttpMessage httpMessage) {
        MediaType contentType = httpMessage.getHeaders().getContentType();
        return contentType == null || !JSON_MEDIA_TYPES.contains(contentType.toString());
    }

    private void logResponse(ClientHttpResponse response, URI uri) {
        try {
            String body = this.getBodyString(response);
            log.info(RESPONSE_MESSAGE_WITH_BODY, new Object[]{uri, response.getStatusCode(), body});
        }
        catch (IOException e) {
            log.error(RESPONSE_CODE_ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String getBodyString(ClientHttpResponse response) {
        try {
            if (response != null && response.getBody() != null) {
                return IOUtils.toString((InputStream)response.getBody(), (String)UTF_8);
            }
            return EMPTY_BODY;
        }
        catch (IOException e) {
            log.error(RESPONSE_BODY_ERROR_MESSAGE, (Throwable)e);
            return EMPTY_BODY;
        }
    }

    private void logRequest(HttpRequest httpRequest, byte[] body) {
        if (this.tracerProperties.isDetailedTracingDisabled() || this.isBodyNotCompatibleForParsing((HttpMessage)httpRequest)) {
            log.info(REQUEST_MESSAGE, (Object)httpRequest.getURI(), (Object)httpRequest.getMethod().name());
        } else {
            log.info(REQUEST_MESSAGE_WITH_BODY, new Object[]{httpRequest.getURI(), httpRequest.getMethod().name(), this.getBody(body)});
        }
    }

    private String getBody(byte[] body) {
        return body == null ? EMPTY_BODY : new String(body);
    }
}

