/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.tracer.config.ObjectMapperFactory;
import org.egov.tracer.http.MultiReadRequestWrapper;
import org.egov.tracer.model.RequestContext;
import org.egov.tracer.model.RequestCorrelationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationIdFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdFilter.class);
    private static final String FAILED_TO_DESERIALIZE_MESSAGE = "Failed to deserialize body";
    private static final String FAILED_TO_UPDATE_REQUEST_MESSAGE = "Failed to update request body with correlation id";
    private static final List<String> JSON_MEDIA_TYPES = Arrays.asList("application/json;charset=UTF-8", "application/json");
    private static final String POST = "POST";
    private static final String NO_CORRELATION_ID_IN_BODY_MESSAGE = "No correlation id present in the body for URI {}";
    private static final String FOUND_CORRELATION_ID_IN_BODY_MESSAGE = "Found correlation id {} in body for URI {}";
    private static final String NO_CORRELATION_ID_IN_HEADER_MESSAGE = "No correlation id found in header for URI {}";
    private static final String FOUND_CORRELATION_ID_IN_HEADER_MESSAGE = "Found correlation id {} in header for URI {}";
    private static final String REQUEST_BODY_LOG_MESSAGE = "Request body - {}";
    private static final String FAILED_TO_LOG_REQUEST_MESSAGE = "Failed to log request body";
    private static final String UTF_8 = "UTF-8";
    private static final String REQUEST_URI_LOG_MESSAGE = "Received request URI: {} with query strings: {}";
    private static final String LOG_RESPONSE_CODE_MESSAGE = "Response code sent: {}";
    private final ObjectMapper objectMapper;
    private boolean inboundHttpRequestBodyLoggingEnabled;

    public CorrelationIdFilter(boolean inboundHttpRequestBodyLoggingEnabled, ObjectMapperFactory objectMapperFactory) {
        this.inboundHttpRequestBodyLoggingEnabled = inboundHttpRequestBodyLoggingEnabled;
        this.objectMapper = objectMapperFactory.create();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        RequestContext.clear();
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        if (this.isBodyCompatibleForParsing(httpRequest)) {
            MultiReadRequestWrapper wrappedRequest = new MultiReadRequestWrapper(httpRequest);
            this.setCorrelationIdFromBody(wrappedRequest);
            this.logRequestURI(httpRequest);
            this.logRequestBody(wrappedRequest);
            filterChain.doFilter((ServletRequest)wrappedRequest, servletResponse);
        } else {
            this.setCorrelationIdFromHeader(httpRequest);
            this.logRequestURI(httpRequest);
            filterChain.doFilter(servletRequest, servletResponse);
        }
        this.logResponse(servletResponse);
    }

    private void logResponse(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        log.info(LOG_RESPONSE_CODE_MESSAGE, (Object)httpServletResponse.getStatus());
    }

    private void logRequestURI(HttpServletRequest httpRequest) {
        String url = httpRequest.getRequestURL().toString();
        String queryString = httpRequest.getQueryString();
        log.info(REQUEST_URI_LOG_MESSAGE, (Object)url, (Object)queryString);
    }

    private void setCorrelationIdFromHeader(HttpServletRequest httpRequest) {
        String correlationIdFromHeader = this.getCorrelationIdFromHeader(httpRequest);
        if (correlationIdFromHeader == null) {
            log.warn(NO_CORRELATION_ID_IN_HEADER_MESSAGE, (Object)httpRequest.getRequestURI());
            RequestContext.setId(this.getRandomCorrelationId());
        } else {
            log.info(FOUND_CORRELATION_ID_IN_HEADER_MESSAGE, (Object)correlationIdFromHeader, (Object)httpRequest.getRequestURI());
            RequestContext.setId(correlationIdFromHeader);
        }
    }

    private void setCorrelationIdFromBody(MultiReadRequestWrapper httpRequest) throws IOException {
        RequestCorrelationId correlationIdFromRequestBody = this.getCorrelationIdFromRequestBody(httpRequest);
        String correlationId = correlationIdFromRequestBody.get();
        if (correlationId == null) {
            log.warn(NO_CORRELATION_ID_IN_BODY_MESSAGE, (Object)httpRequest.getRequestURI());
            this.setCorrelationIdFromHeader((HttpServletRequest)httpRequest);
            this.setCorrelationIdToRequestBody(httpRequest, correlationIdFromRequestBody);
        } else {
            log.info(FOUND_CORRELATION_ID_IN_BODY_MESSAGE, (Object)correlationIdFromRequestBody, (Object)httpRequest.getRequestURI());
            RequestContext.setId(correlationId);
        }
    }

    private boolean isBodyCompatibleForParsing(HttpServletRequest httpRequest) {
        return POST.equals(httpRequest.getMethod()) && JSON_MEDIA_TYPES.contains(httpRequest.getContentType());
    }

    private String getCorrelationIdFromHeader(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("x-correlation-id");
    }

    private RequestCorrelationId getCorrelationIdFromRequestBody(MultiReadRequestWrapper httpRequest) {
        try {
            HashMap requestBody = (HashMap)this.objectMapper.readValue((InputStream)httpRequest.getInputStream(), HashMap.class);
            return new RequestCorrelationId(requestBody);
        }
        catch (IOException e) {
            log.error(FAILED_TO_DESERIALIZE_MESSAGE, (Throwable)e);
            return new RequestCorrelationId(null);
        }
    }

    private void setCorrelationIdToRequestBody(MultiReadRequestWrapper httpRequest, RequestCorrelationId requestCorrelationId) {
        try {
            this.updateRequestInfoWithCorrelationId(httpRequest, requestCorrelationId);
        }
        catch (IOException e) {
            log.error(FAILED_TO_UPDATE_REQUEST_MESSAGE, (Throwable)e);
        }
    }

    private void updateRequestInfoWithCorrelationId(MultiReadRequestWrapper httpRequest, RequestCorrelationId requestCorrelationId) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String correlationId = RequestContext.getId();
        HashMap<String, Object> updatedRequestInfo = requestCorrelationId.update(correlationId);
        this.objectMapper.writeValue((OutputStream)out, updatedRequestInfo);
        httpRequest.update(out);
    }

    private void logRequestBody(MultiReadRequestWrapper requestWrapper) {
        if (this.inboundHttpRequestBodyLoggingEnabled) {
            try {
                String requestBody = IOUtils.toString((InputStream)requestWrapper.getInputStream(), (String)UTF_8);
                log.info(REQUEST_BODY_LOG_MESSAGE, (Object)requestBody);
            }
            catch (IOException e) {
                log.error(FAILED_TO_LOG_REQUEST_MESSAGE, (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    private String getRandomCorrelationId() {
        return UUID.randomUUID().toString();
    }
}

