/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.egov.tracer.config.ObjectMapperFactory;
import org.egov.tracer.config.TracerProperties;
import org.egov.tracer.model.RequestContext;
import org.egov.tracer.model.RequestCorrelationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;

@Aspect
public class KafkaListenerLoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerLoggingAspect.class);
    private static final String RECEIVED_MESSAGE_WITH_BODY = "Received message from topic: {} with body {}";
    private static final String RECEIVED_MESSAGE = "Received message from topic: {}";
    private static final String PROCESSED_SUCCESS_MESSAGE = "Processed message successfully";
    private static final String EXCEPTION_MESSAGE = "Exception processing message";
    private static final String NOT_AVAILABLE = "<NOT-AVAILABLE>";
    private static final String CONVERSION_FAILED_MESSAGE = "Failed to convert String to HashMap";
    private ObjectMapper objectMapper;
    private TracerProperties tracerProperties;

    public KafkaListenerLoggingAspect(TracerProperties tracerProperties, ObjectMapperFactory objectMapperFactory) {
        this.tracerProperties = tracerProperties;
        this.objectMapper = objectMapperFactory.create();
    }

    @Pointcut(value=" within(org.egov..*) && @annotation(org.springframework.kafka.annotation.KafkaListener)")
    public void anyKafkaConsumer() {
    }

    @Around(value="anyKafkaConsumer() ")
    public Object logAction(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        try {
            this.setCorrelationId(parameterAnnotations, args);
            String receivedTopicName = this.getParameterWithTopicAnnotation(parameterAnnotations, args);
            if (this.tracerProperties.isDetailedTracingEnabled()) {
                String messageBodyAsString = this.getMessageBodyAsString(args, parameterAnnotations);
                log.info(RECEIVED_MESSAGE_WITH_BODY, (Object)receivedTopicName, (Object)messageBodyAsString);
            } else {
                log.info(RECEIVED_MESSAGE, (Object)receivedTopicName);
            }
            Object result = joinPoint.proceed();
            log.info(PROCESSED_SUCCESS_MESSAGE);
            return result;
        }
        catch (Exception e) {
            log.error(EXCEPTION_MESSAGE, (Throwable)e);
            throw e;
        }
    }

    private void setCorrelationId(Annotation[][] parameterAnnotations, Object[] args) {
        String correlationId = this.getCorrelationId(parameterAnnotations, args);
        RequestContext.setId((String)correlationId);
    }

    private String getCorrelationId(Annotation[][] parameterAnnotations, Object[] args) {
        HashMap requestMap = this.getMessageBody(parameterAnnotations, args);
        String correlationIdFromRequest = new RequestCorrelationId(requestMap).get();
        return correlationIdFromRequest == null ? this.getRandomCorrelationId() : correlationIdFromRequest;
    }

    private String getRandomCorrelationId() {
        return UUID.randomUUID().toString();
    }

    private String getMessageBodyAsString(Object[] args, Annotation[][] parameterAnnotations) throws JsonProcessingException {
        Object parameterWithPayloadAnnotation = this.getParameterWithPayloadAnnotation(parameterAnnotations, args);
        if (parameterWithPayloadAnnotation != null) {
            if (parameterWithPayloadAnnotation instanceof String) {
                return (String)parameterWithPayloadAnnotation;
            }
            return this.objectMapper.writeValueAsString(parameterWithPayloadAnnotation);
        }
        return NOT_AVAILABLE;
    }

    private Object getParameterWithPayloadAnnotation(Annotation[][] parameterAnnotations, Object[] args) {
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean isPayloadAnnotationPresent = this.isPayloadAnnotationPresent(annotations);
            if (!isPayloadAnnotationPresent) continue;
            return args[i];
        }
        return null;
    }

    private boolean isPayloadAnnotationPresent(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        return Stream.of(annotations).anyMatch(annotation -> annotation.annotationType().getAnnotationsByType(Payload.class) != null);
    }

    private String getParameterWithTopicAnnotation(Annotation[][] parameterAnnotations, Object[] args) {
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            if (!this.isTopicAnnotationPresent(annotations)) continue;
            return (String)args[i];
        }
        return NOT_AVAILABLE;
    }

    private boolean isTopicAnnotationPresent(Annotation[] annotations) {
        if (annotations == null) {
            return false;
        }
        return Stream.of(annotations).anyMatch(arg_0 -> this.isTopicNameHeaderAnnotationPresent(arg_0));
    }

    private boolean isTopicNameHeaderAnnotationPresent(Annotation annotation) {
        return annotation instanceof Header && "kafka_receivedTopic".equals(((Header)annotation).value());
    }

    private HashMap<String, Object> getMessageBody(Annotation[][] parameterAnnotations, Object[] args) {
        Object parameterWithPayloadAnnotation = this.getParameterWithPayloadAnnotation(parameterAnnotations, args);
        if (parameterWithPayloadAnnotation != null) {
            return this.convertToMap(parameterWithPayloadAnnotation);
        }
        return null;
    }

    private HashMap<String, Object> convertToMap(Object parameterObject) {
        if (parameterObject instanceof String) {
            try {
                return (HashMap)this.objectMapper.readValue((String)parameterObject, HashMap.class);
            }
            catch (IOException e) {
                log.error(CONVERSION_FAILED_MESSAGE, (Throwable)e);
                return null;
            }
        }
        return (HashMap)this.objectMapper.convertValue(parameterObject, HashMap.class);
    }
}

