/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.common.errors.SerializationException;
import org.egov.tracer.model.ErrorQueueContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class ErrorQueueProducer {
    private static final Logger log = LoggerFactory.getLogger(ErrorQueueProducer.class);
    @Autowired
    private KafkaTemplate<String, Object> kafkaTemplate;
    @Value(value="${error.queue.topic:egov.error}")
    private String topic;

    public void sendMessage(ErrorQueueContract errorQueueContract) {
        try {
            this.kafkaTemplate.send(this.topic, (Object)errorQueueContract);
        }
        catch (SerializationException serializationException) {
            log.info("SerializationException exception occured while sending exception to error queue");
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                this.kafkaTemplate.send(this.topic, (Object)objectMapper.writeValueAsString((Object)errorQueueContract));
            }
            catch (JsonProcessingException e) {
                log.info("exception occured while converting ErrorQueueContract to json string");
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            log.info("exception occured while sending exception to error queue");
            ex.printStackTrace();
        }
    }
}

