/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice
@RestController
@Order(value=0x7FFFFFFF)
public class UnhandledExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(UnhandledExceptionControllerAdvice.class);

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public String handleServerError(Exception ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return ex.getMessage();
    }
}

