/*
 * Decompiled with CFR 0.152.
 */
package org.egov.tracer;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.tracer.kafka.ErrorQueueProducer;
import org.egov.tracer.model.CustomBindingResultExceprion;
import org.egov.tracer.model.CustomException;
import org.egov.tracer.model.Error;
import org.egov.tracer.model.ErrorQueueContract;
import org.egov.tracer.model.ErrorRes;
import org.egov.tracer.model.ServiceCallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class ExceptionAdvise {
    private static final Logger log = LoggerFactory.getLogger(ExceptionAdvise.class);
    @Autowired
    private ErrorQueueProducer errorQueueProducer;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<?> exceptionHandler(HttpServletRequest request, Exception ex) {
        log.info("ExceptionAdvise exceptio  webRequest:");
        ex.printStackTrace();
        String body = this.readRequestBody(request);
        ErrorRes errorRes = new ErrorRes();
        ArrayList errors = new ArrayList();
        if (ex instanceof MethodArgumentNotValidException) {
            log.info("MethodArgumentNotValidException ");
            MethodArgumentNotValidException argumentNotValidException = (MethodArgumentNotValidException)ex;
            errorRes.setErrors(this.getBindingErrors(argumentNotValidException.getBindingResult(), errors));
        } else if (ex instanceof CustomBindingResultExceprion) {
            log.info("CustomBindingResultExceprion block");
            CustomBindingResultExceprion customBindingResultExceprion = (CustomBindingResultExceprion)ex;
            errorRes.setErrors(this.getBindingErrors(customBindingResultExceprion.getBindingResult(), errors));
        } else if (ex instanceof CustomException) {
            log.info("CustomException block");
            CustomException customException = (CustomException)ex;
            this.populateCustomErrros(customException, errors);
            errorRes.setErrors(errors);
        } else if (ex instanceof ServiceCallException) {
            log.info("ServiceCallException block");
            ServiceCallException serviceCallException = (ServiceCallException)ex;
            this.sendErrorMessage(body, ex, request.getRequestURL().toString(), errorRes);
            DocumentContext documentContext = JsonPath.parse((String)serviceCallException.getError());
            log.info("exceptionHandler:" + documentContext);
            LinkedHashMap linkedHashMap = (LinkedHashMap)documentContext.json();
            return new ResponseEntity((Object)linkedHashMap, HttpStatus.BAD_REQUEST);
        }
        this.sendErrorMessage(body, ex, request.getRequestURL().toString(), errorRes);
        return new ResponseEntity((Object)errorRes, HttpStatus.BAD_REQUEST);
    }

    private List<Error> getBindingErrors(BindingResult bindingResult, List<Error> errors) {
        List objectErrors = bindingResult.getAllErrors();
        for (ObjectError objectError : objectErrors) {
            Error error = new Error();
            String[] codes = objectError.getCodes();
            error.setCode(codes[0]);
            error.setMessage(objectError.getDefaultMessage());
            errors.add(error);
        }
        return errors;
    }

    private void populateCustomErrros(CustomException customException, List<Error> errors) {
        Map map = customException.getErrors();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                Error error = new Error();
                error.setCode((String)entry.getKey());
                error.setMessage((String)entry.getValue());
                errors.add(error);
            }
        } else {
            Error error = new Error();
            error.setCode(customException.getCode());
            error.setMessage(customException.getMessage());
            errors.add(error);
        }
    }

    private String readRequestBody(HttpServletRequest httpServletRequest) {
        log.info("ExceptionAdvise readRequestBody");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)httpServletRequest.getInputStream()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String line = "";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String body = stringBuilder.toString();
        System.out.println("readRequestBody body:" + body);
        return body;
    }

    public void sendErrorMessage(String body, Exception ex, String source, ErrorRes errorRes) {
        DocumentContext documentContext = JsonPath.parse((String)body);
        log.info("sendErrorMessage documentContext:" + documentContext.json());
        StackTraceElement[] elements = ex.getStackTrace();
        ErrorQueueContract errorQueueContract = ErrorQueueContract.builder().body(documentContext.json()).source(source).ts(Long.valueOf(new Date().getTime())).errorRes(errorRes).exception(Arrays.asList(elements)).message(ex.getMessage()).build();
        log.info("sendErrorMessage errorQueueContract:" + errorQueueContract);
        this.errorQueueProducer.sendMessage(errorQueueContract);
    }
}

