/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import org.egov.common.exception.MethodNotFoundException;
import org.springframework.util.ReflectionUtils;

public class UUIDEnrichmentUtil {
    private UUIDEnrichmentUtil() {
    }

    public static <T> void enrichRandomUuid(T obj, String field) {
        Class<?> objClass = UUIDEnrichmentUtil.getObjClass(obj);
        Method setIdMethod = UUIDEnrichmentUtil.getMethod(UUIDEnrichmentUtil.getSetterMethodName(field), objClass);
        if (obj instanceof List) {
            IntStream.range(0, ((List)obj).size()).forEach(i -> ReflectionUtils.invokeMethod((Method)setIdMethod, ((List)obj).get(i), (Object[])new Object[]{UUID.randomUUID().toString()}));
        } else {
            ReflectionUtils.invokeMethod((Method)setIdMethod, obj, (Object[])new Object[]{UUID.randomUUID().toString()});
        }
    }

    private static <T> Class<?> getObjClass(T obj) {
        if (obj instanceof List) {
            return ((List)obj).stream().findAny().get().getClass();
        }
        return obj.getClass();
    }

    private static Method getMethod(String methodName, Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new MethodNotFoundException("Method " + methodName + " not found in class " + clazz.getName()));
    }

    private static String getSetterMethodName(String field) {
        return "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
    }
}

