/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.workflow;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.workflow.ProcessInstance;

public class ProcessInstanceRequest {
    @JsonProperty(value="RequestInfo")
    private RequestInfo requestInfo;
    @JsonProperty(value="ProcessInstances")
    @Valid
    @NotNull
    private List<ProcessInstance> processInstances;

    public ProcessInstanceRequest addProcessInstanceItem(ProcessInstance processInstanceItem) {
        if (this.processInstances == null) {
            this.processInstances = new ArrayList<ProcessInstance>();
        }
        this.processInstances.add(processInstanceItem);
        return this;
    }

    public static ProcessInstanceRequestBuilder builder() {
        return new ProcessInstanceRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProcessInstance> getProcessInstances() {
        return this.processInstances;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProcessInstances")
    public void setProcessInstances(List<ProcessInstance> processInstances) {
        this.processInstances = processInstances;
    }

    public ProcessInstanceRequest(RequestInfo requestInfo, List<ProcessInstance> processInstances) {
        this.requestInfo = requestInfo;
        this.processInstances = processInstances;
    }

    public ProcessInstanceRequest() {
    }

    public String toString() {
        return "ProcessInstanceRequest(requestInfo=" + this.getRequestInfo() + ", processInstances=" + this.getProcessInstances() + ")";
    }

    public static class ProcessInstanceRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProcessInstance> processInstances;

        ProcessInstanceRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProcessInstanceRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProcessInstances")
        public ProcessInstanceRequestBuilder processInstances(List<ProcessInstance> processInstances) {
            this.processInstances = processInstances;
            return this;
        }

        public ProcessInstanceRequest build() {
            return new ProcessInstanceRequest(this.requestInfo, this.processInstances);
        }

        public String toString() {
            return "ProcessInstanceRequest.ProcessInstanceRequestBuilder(requestInfo=" + this.requestInfo + ", processInstances=" + this.processInstances + ")";
        }
    }
}

