/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.workflow;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.models.Document;
import org.egov.common.contract.request.User;
import org.egov.common.contract.workflow.State;

public class ProcessInstance {
    @Size(max=64)
    @JsonProperty(value="id")
    private @Size(max=64) String id;
    @NotNull
    @Size(max=128)
    @JsonProperty(value="tenantId")
    private @NotNull @Size(max=128) String tenantId;
    @NotNull
    @Size(max=128)
    @JsonProperty(value="businessService")
    private @NotNull @Size(max=128) String businessService;
    @NotNull
    @Size(max=128)
    @JsonProperty(value="businessId")
    private @NotNull @Size(max=128) String businessId;
    @NotNull
    @Size(max=128)
    @JsonProperty(value="action")
    private @NotNull @Size(max=128) String action;
    @NotNull
    @Size(max=64)
    @JsonProperty(value="moduleName")
    private @NotNull @Size(max=64) String moduleName;
    @JsonProperty(value="state")
    private State state;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents;
    @JsonProperty(value="assignes")
    private List<User> assignes;

    public ProcessInstance addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        if (!this.documents.contains(documentsItem)) {
            this.documents.add(documentsItem);
        }
        return this;
    }

    public static ProcessInstanceBuilder builder() {
        return new ProcessInstanceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getBusinessService() {
        return this.businessService;
    }

    public String getBusinessId() {
        return this.businessId;
    }

    public String getAction() {
        return this.action;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public State getState() {
        return this.state;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public List<User> getAssignes() {
        return this.assignes;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="businessService")
    public void setBusinessService(String businessService) {
        this.businessService = businessService;
    }

    @JsonProperty(value="businessId")
    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    @JsonProperty(value="action")
    public void setAction(String action) {
        this.action = action;
    }

    @JsonProperty(value="moduleName")
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @JsonProperty(value="state")
    public void setState(State state) {
        this.state = state;
    }

    @JsonProperty(value="comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="assignes")
    public void setAssignes(List<User> assignes) {
        this.assignes = assignes;
    }

    public ProcessInstance(String id, String tenantId, String businessService, String businessId, String action, String moduleName, State state, String comment, List<Document> documents, List<User> assignes) {
        this.id = id;
        this.tenantId = tenantId;
        this.businessService = businessService;
        this.businessId = businessId;
        this.action = action;
        this.moduleName = moduleName;
        this.state = state;
        this.comment = comment;
        this.documents = documents;
        this.assignes = assignes;
    }

    public ProcessInstance() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessInstance)) {
            return false;
        }
        ProcessInstance other = (ProcessInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessInstance(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", businessService=" + this.getBusinessService() + ", businessId=" + this.getBusinessId() + ", action=" + this.getAction() + ", moduleName=" + this.getModuleName() + ", state=" + this.getState() + ", comment=" + this.getComment() + ", documents=" + this.getDocuments() + ", assignes=" + this.getAssignes() + ")";
    }

    public static class ProcessInstanceBuilder {
        private String id;
        private String tenantId;
        private String businessService;
        private String businessId;
        private String action;
        private String moduleName;
        private State state;
        private String comment;
        private List<Document> documents;
        private List<User> assignes;

        ProcessInstanceBuilder() {
        }

        @JsonProperty(value="id")
        public ProcessInstanceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProcessInstanceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="businessService")
        public ProcessInstanceBuilder businessService(String businessService) {
            this.businessService = businessService;
            return this;
        }

        @JsonProperty(value="businessId")
        public ProcessInstanceBuilder businessId(String businessId) {
            this.businessId = businessId;
            return this;
        }

        @JsonProperty(value="action")
        public ProcessInstanceBuilder action(String action) {
            this.action = action;
            return this;
        }

        @JsonProperty(value="moduleName")
        public ProcessInstanceBuilder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        @JsonProperty(value="state")
        public ProcessInstanceBuilder state(State state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="comment")
        public ProcessInstanceBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @JsonProperty(value="documents")
        public ProcessInstanceBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="assignes")
        public ProcessInstanceBuilder assignes(List<User> assignes) {
            this.assignes = assignes;
            return this;
        }

        public ProcessInstance build() {
            return new ProcessInstance(this.id, this.tenantId, this.businessService, this.businessId, this.action, this.moduleName, this.state, this.comment, this.documents, this.assignes);
        }

        public String toString() {
            return "ProcessInstance.ProcessInstanceBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", businessService=" + this.businessService + ", businessId=" + this.businessId + ", action=" + this.action + ", moduleName=" + this.moduleName + ", state=" + this.state + ", comment=" + this.comment + ", documents=" + this.documents + ", assignes=" + this.assignes + ")";
        }
    }
}

