/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.contract.workflow;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.contract.workflow.BusinessService;

public class BusinessServiceResponse {
    @JsonProperty(value="ResponseInfo")
    private ResponseInfo responseInfo;
    @JsonProperty(value="BusinessServices")
    @Valid
    @NotNull
    private List<BusinessService> businessServices;

    public BusinessServiceResponse addBusinessServiceItem(BusinessService businessServiceItem) {
        if (this.businessServices == null) {
            this.businessServices = new ArrayList<BusinessService>();
        }
        this.businessServices.add(businessServiceItem);
        return this;
    }

    public static BusinessServiceResponseBuilder builder() {
        return new BusinessServiceResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<BusinessService> getBusinessServices() {
        return this.businessServices;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="BusinessServices")
    public void setBusinessServices(List<BusinessService> businessServices) {
        this.businessServices = businessServices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessServiceResponse)) {
            return false;
        }
        BusinessServiceResponse other = (BusinessServiceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !((Object)this$responseInfo).equals(other$responseInfo)) {
            return false;
        }
        List<BusinessService> this$businessServices = this.getBusinessServices();
        List<BusinessService> other$businessServices = other.getBusinessServices();
        return !(this$businessServices == null ? other$businessServices != null : !((Object)this$businessServices).equals(other$businessServices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessServiceResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : ((Object)$responseInfo).hashCode());
        List<BusinessService> $businessServices = this.getBusinessServices();
        result = result * 59 + ($businessServices == null ? 43 : ((Object)$businessServices).hashCode());
        return result;
    }

    public BusinessServiceResponse() {
    }

    public BusinessServiceResponse(ResponseInfo responseInfo, List<BusinessService> businessServices) {
        this.responseInfo = responseInfo;
        this.businessServices = businessServices;
    }

    public String toString() {
        return "BusinessServiceResponse(responseInfo=" + this.getResponseInfo() + ", businessServices=" + this.getBusinessServices() + ")";
    }

    public static class BusinessServiceResponseBuilder {
        private ResponseInfo responseInfo;
        private List<BusinessService> businessServices;

        BusinessServiceResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public BusinessServiceResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="BusinessServices")
        public BusinessServiceResponseBuilder businessServices(List<BusinessService> businessServices) {
            this.businessServices = businessServices;
            return this;
        }

        public BusinessServiceResponse build() {
            return new BusinessServiceResponse(this.responseInfo, this.businessServices);
        }

        public String toString() {
            return "BusinessServiceResponse.BusinessServiceResponseBuilder(responseInfo=" + this.responseInfo + ", businessServices=" + this.businessServices + ")";
        }
    }
}

