/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.utils;

import org.egov.common.contract.models.AuditDetails;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.exception.NullCheckException;
import org.springframework.util.ObjectUtils;

public class AuditDetailsEnrichmentUtil {
    public static void enrichAuditDetails(AuditDetails auditDetails, RequestInfo requestInfo, Boolean isCreateRequest) {
        AuditDetailsEnrichmentUtil.validateInput(auditDetails, requestInfo, isCreateRequest);
        auditDetails.setLastModifiedTime(System.currentTimeMillis());
        auditDetails.setLastModifiedBy(requestInfo.getUserInfo().getUuid());
        if (isCreateRequest.booleanValue()) {
            auditDetails.setCreatedTime(System.currentTimeMillis());
            auditDetails.setCreatedBy(requestInfo.getUserInfo().getUuid());
        }
    }

    private static void validateInput(AuditDetails auditDetails, RequestInfo requestInfo, Boolean isCreateRequest) {
        if (ObjectUtils.isEmpty((Object)isCreateRequest)) {
            throw new NullCheckException("IsCreateRequest flag being sent to enrichAuditDetails method must not be null");
        }
        if (ObjectUtils.isEmpty((Object)auditDetails)) {
            throw new NullCheckException("AuditDetails being sent to enrichAuditDetails method must not be null");
        }
        if (ObjectUtils.isEmpty((Object)requestInfo)) {
            throw new NullCheckException("RequestInfo being sent to enrichAuditDetails method must not be null");
        }
        if (ObjectUtils.isEmpty((Object)requestInfo.getUserInfo())) {
            throw new NullCheckException("UserInfo present inside RequestInfo being sent to enrichAuditDetails method must not be null");
        }
        if (!isCreateRequest.booleanValue()) {
            if (ObjectUtils.isEmpty((Object)auditDetails.getCreatedBy())) {
                throw new NullCheckException("CreatedBy present inside AuditDetails being sent to enrichAuditDetails method must not be null in case of update request");
            }
            if (ObjectUtils.isEmpty((Object)auditDetails.getCreatedTime())) {
                throw new NullCheckException("CreatedTime present inside AuditDetails being sent to enrichAuditDetails method must not be null in case of update request");
            }
        }
    }
}

